/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.extension.MonitorServiceAddStepHandler;
import org.hawkular.agent.monitor.extension.RemoteDMRAttributes;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.ProtocolService;
import org.hawkular.agent.monitor.protocol.ProtocolServices;
import org.hawkular.agent.monitor.service.MonitorService;
import org.hawkular.agent.wildfly.util.Util;
import org.hawkular.agent.wildfly.util.WildflyCompatibilityUtils;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public class RemoteDMRAdd
extends MonitorServiceAddStepHandler {
    public static final RemoteDMRAdd INSTANCE = new RemoteDMRAdd();

    private RemoteDMRAdd() {
        super(RemoteDMRAttributes.ATTRIBUTES);
    }

    @Override
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isBooting()) {
            return;
        }
        MonitorService monitorService = this.getMonitorService(context);
        if (monitorService == null) {
            return;
        }
        AgentCoreEngineConfiguration config = Util.getMonitorServiceConfiguration(context);
        String newEndpointName = WildflyCompatibilityUtils.getCurrentAddressValue(context, operation);
        AgentCoreEngineConfiguration.EndpointConfiguration endpointConfig = (AgentCoreEngineConfiguration.EndpointConfiguration)config.getDmrConfiguration().getEndpoints().get(newEndpointName);
        if (endpointConfig.isEnabled()) {
            ProtocolServices newServices = monitorService.createProtocolServicesBuilder().dmrProtocolService(null, config.getDmrConfiguration()).build();
            EndpointService endpointService = (EndpointService)newServices.getDmrProtocolService().getEndpointServices().get(newEndpointName);
            ProtocolService dmrService = monitorService.getProtocolServices().getDmrProtocolService();
            dmrService.add(endpointService);
        }
    }
}

