/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.prometheus.walkers;

import java.net.URL;
import org.hawkular.agent.prometheus.types.Counter;
import org.hawkular.agent.prometheus.types.Gauge;
import org.hawkular.agent.prometheus.types.Histogram;
import org.hawkular.agent.prometheus.types.MetricFamily;
import org.hawkular.agent.prometheus.types.Summary;
import org.hawkular.agent.prometheus.walkers.PrometheusMetricsWalker;

public class SimplePrometheusMetricsWalker
implements PrometheusMetricsWalker {
    private final URL url;

    public SimplePrometheusMetricsWalker() {
        this(null);
    }

    public SimplePrometheusMetricsWalker(URL url) {
        this.url = url;
    }

    @Override
    public void walkStart() {
        if (this.url != null) {
            System.out.println("Scraping metrics from Prometheus protocol endpoint: " + this.url);
        }
    }

    @Override
    public void walkFinish(int familiesProcessed, int metricsProcessed) {
        if (metricsProcessed == 0) {
            System.out.println("There are no metrics");
        }
    }

    @Override
    public void walkMetricFamily(MetricFamily family, int index) {
        System.out.printf("* %s (%s): %s\n", new Object[]{family.getName(), family.getType(), family.getHelp()});
    }

    @Override
    public void walkCounterMetric(MetricFamily family, Counter metric, int index) {
        System.out.printf("  +%2d. %s%s [%f]\n", index, metric.getName(), this.buildLabelListString(metric.getLabels(), "{", "}"), metric.getValue());
    }

    @Override
    public void walkGaugeMetric(MetricFamily family, Gauge metric, int index) {
        System.out.printf("  +%2d. %s%s [%f]\n", index, metric.getName(), this.buildLabelListString(metric.getLabels(), "{", "}"), metric.getValue());
    }

    @Override
    public void walkSummaryMetric(MetricFamily family, Summary metric, int index) {
        System.out.printf("  +%2d. %s%s [%d/%f] {%s}\n", index, metric.getName(), this.buildLabelListString(metric.getLabels(), "{", "}"), metric.getSampleCount(), metric.getSampleSum(), metric.getQuantiles());
    }

    @Override
    public void walkHistogramMetric(MetricFamily family, Histogram metric, int index) {
        System.out.printf("  +%2d. %s%s [%d/%f] {%s}\n", index, metric.getName(), this.buildLabelListString(metric.getLabels(), "{", "}"), metric.getSampleCount(), metric.getSampleSum(), metric.getBuckets());
    }
}

