/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.prometheus.types;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Metric {
    private final String name;
    private final Map<String, String> labels;

    protected Metric(Builder<?> builder) {
        if (((Builder)builder).name == null) {
            throw new IllegalArgumentException("Need to set name");
        }
        this.name = ((Builder)builder).name;
        this.labels = ((Builder)builder).labels;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getLabels() {
        if (this.labels == null) {
            return Collections.emptyMap();
        }
        return this.labels;
    }

    public static abstract class Builder<B extends Builder<?>> {
        private String name;
        private Map<String, String> labels;

        public B setName(String name) {
            this.name = name;
            return (B)this;
        }

        public B addLabel(String name, String value) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            this.labels.put(name, value);
            return (B)this;
        }

        public B addLabels(Map<String, String> map) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            this.labels.putAll(map);
            return (B)this;
        }

        public abstract <T extends Metric> T build();
    }
}

