/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.prometheus.walkers;

import java.util.Iterator;
import java.util.Map;
import org.hawkular.agent.prometheus.Util;
import org.hawkular.agent.prometheus.types.Counter;
import org.hawkular.agent.prometheus.types.Gauge;
import org.hawkular.agent.prometheus.types.Histogram;
import org.hawkular.agent.prometheus.types.MetricFamily;
import org.hawkular.agent.prometheus.types.Summary;
import org.hawkular.agent.prometheus.walkers.PrometheusMetricsWalker;

public class JSONPrometheusMetricsWalker
implements PrometheusMetricsWalker {
    @Override
    public void walkStart() {
        System.out.println("[");
    }

    @Override
    public void walkFinish(int familiesProcessed, int metricsProcessed) {
        if (familiesProcessed > 0) {
            System.out.println("    ]");
            System.out.println("  }");
        }
        System.out.println("]");
    }

    @Override
    public void walkMetricFamily(MetricFamily familyInfo, int index) {
        if (index > 0) {
            System.out.printf("    ]\n", new Object[0]);
            System.out.printf("  },\n", new Object[0]);
        }
        System.out.printf("  {\n", new Object[0]);
        System.out.printf("    \"name\":\"%s\",\n", familyInfo.getName());
        System.out.printf("    \"help\":\"%s\",\n", familyInfo.getHelp());
        System.out.printf("    \"type\":\"%s\",\n", new Object[]{familyInfo.getType()});
        System.out.printf("    \"metrics\":[\n", new Object[0]);
    }

    @Override
    public void walkCounterMetric(MetricFamily family, Counter metric, int index) {
        System.out.printf("      {\n", new Object[0]);
        this.outputLabels(metric.getLabels());
        System.out.printf("        \"value\":\"%s\"\n", Util.convertDoubleToString(metric.getValue()));
        if (index + 1 == family.getMetrics().size()) {
            System.out.printf("      }\n", new Object[0]);
        } else {
            System.out.printf("      },\n", new Object[0]);
        }
    }

    @Override
    public void walkGaugeMetric(MetricFamily family, Gauge metric, int index) {
        System.out.printf("      {\n", new Object[0]);
        this.outputLabels(metric.getLabels());
        System.out.printf("        \"value\":\"%s\"\n", Util.convertDoubleToString(metric.getValue()));
        if (index + 1 == family.getMetrics().size()) {
            System.out.printf("      }\n", new Object[0]);
        } else {
            System.out.printf("      },\n", new Object[0]);
        }
    }

    @Override
    public void walkSummaryMetric(MetricFamily family, Summary metric, int index) {
        System.out.printf("      {\n", new Object[0]);
        this.outputLabels(metric.getLabels());
        if (!metric.getQuantiles().isEmpty()) {
            System.out.printf("        \"quantiles\":{\n", new Object[0]);
            Iterator<Summary.Quantile> iter = metric.getQuantiles().iterator();
            while (iter.hasNext()) {
                Summary.Quantile quantile = iter.next();
                System.out.printf("          \"%f\":\"%f\"%s\n", quantile.getQuantile(), quantile.getValue(), iter.hasNext() ? "," : "");
            }
            System.out.printf("        },\n", new Object[0]);
        }
        System.out.printf("        \"count\":\"%d\",\n", metric.getSampleCount());
        System.out.printf("        \"sum\":\"%s\"\n", Util.convertDoubleToString(metric.getSampleSum()));
        if (index + 1 == family.getMetrics().size()) {
            System.out.printf("      }\n", new Object[0]);
        } else {
            System.out.printf("      },\n", new Object[0]);
        }
    }

    @Override
    public void walkHistogramMetric(MetricFamily family, Histogram metric, int index) {
        System.out.printf("      {\n", new Object[0]);
        this.outputLabels(metric.getLabels());
        if (!metric.getBuckets().isEmpty()) {
            System.out.printf("        \"buckets\":{\n", new Object[0]);
            Iterator<Histogram.Bucket> iter = metric.getBuckets().iterator();
            while (iter.hasNext()) {
                Histogram.Bucket bucket = iter.next();
                System.out.printf("          \"%f\":\"%d\"%s\n", bucket.getUpperBound(), bucket.getCumulativeCount(), iter.hasNext() ? "," : "");
            }
            System.out.printf("        },\n", new Object[0]);
        }
        System.out.printf("        \"count\":\"%d\",\n", metric.getSampleCount());
        System.out.printf("        \"sum\":\"%s\"\n", Util.convertDoubleToString(metric.getSampleSum()));
        if (index + 1 == family.getMetrics().size()) {
            System.out.printf("      }\n", new Object[0]);
        } else {
            System.out.printf("      },\n", new Object[0]);
        }
    }

    private void outputLabels(Map<String, String> labels) {
        if (labels == null || labels.isEmpty()) {
            return;
        }
        System.out.printf("        \"labels\":{\n", new Object[0]);
        Iterator<Map.Entry<String, String>> iter = labels.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> labelPair = iter.next();
            String comma = iter.hasNext() ? "," : "";
            System.out.printf("          \"%s\":\"%s\"%s\n", labelPair.getKey(), labelPair.getValue(), comma);
        }
        System.out.printf("        },\n", new Object[0]);
    }
}

