/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.wildfly.module.installer;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import org.hawkular.wildfly.module.installer.DeploymentConfiguration;
import org.hawkular.wildfly.module.installer.ExtensionDeploymentException;
import org.hawkular.wildfly.module.installer.JBossModule;
import org.hawkular.wildfly.module.installer.RegisterExtension;
import org.hawkular.wildfly.module.installer.RegisterModuleConfiguration;
import org.jboss.logging.Logger;

public class ExtensionDeployer {
    private final Logger log = Logger.getLogger(this.getClass());
    private File targetServerConfigAbsolute;
    private File sourceServerConfigBackupAbsolute;
    private File modulesHomeAbsolute;

    public void install(DeploymentConfiguration configuration) throws ExtensionDeploymentException {
        this.log.debug((Object)"Validating configuration");
        this.validConfiguration(configuration);
        JBossModule module = null;
        RegisterModuleConfiguration resolvedOptions = new RegisterModuleConfiguration();
        if (configuration.getModule() != null) {
            try {
                this.log.debugf("Reading module from [%s]", (Object)configuration.getModule());
                module = JBossModule.readFromURL(configuration.getModule());
            }
            catch (Exception e) {
                throw new ExtensionDeploymentException("Failed to read module", e);
            }
            try {
                List<File> installedFiles = module.installTo(this.modulesHomeAbsolute);
                resolvedOptions = this.resolveBundledXmlSnippets(installedFiles, configuration);
            }
            catch (Exception e) {
                throw new ExtensionDeploymentException("Failed to install module", e);
            }
        }
        try {
            RegisterModuleConfiguration options = new RegisterModuleConfiguration();
            if (module != null) {
                options.withExtension(module.getModuleId());
            }
            if (configuration.getConfigType() != null) {
                options.configType(configuration.getConfigType());
            }
            options.targetServerConfig(this.targetServerConfigAbsolute).sourceServerConfig(this.sourceServerConfigBackupAbsolute).subsystem(configuration.getSubsystem()).socketBinding(configuration.getSocketBinding()).socketBindingGroups(configuration.getSocketBindingGroups()).xmlEdits(configuration.getEdit()).profiles(configuration.getProfiles()).failNoMatch(configuration.isFailNoMatch());
            resolvedOptions.extend(options);
            this.log.debugf("Proceeding with \n%s", (Object)resolvedOptions);
            this.register(resolvedOptions);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new ExtensionDeploymentException("Failed to update server configuration file", e);
        }
    }

    private RegisterModuleConfiguration resolveBundledXmlSnippets(List<File> installedFiles, DeploymentConfiguration configuration) throws Exception {
        RegisterModuleConfiguration options = new RegisterModuleConfiguration();
        boolean overrideSubsystem = false;
        boolean overrideSocketBinding = false;
        if (configuration.getSubsystem() != null) {
            options.subsystem(configuration.getSubsystem());
            overrideSubsystem = true;
            this.log.debugf("Using user-provided subsystem snippet: [%s]", (Object)options.getSubsystem());
        }
        if (configuration.getSocketBinding() != null) {
            options.socketBinding(configuration.getSocketBinding());
            overrideSocketBinding = true;
            this.log.debugf("Using user-provided socketBinding snippet: [%s]", (Object)options.getSocketBinding());
        }
        if (!overrideSubsystem || !overrideSocketBinding) {
            for (File file : installedFiles) {
                if (!overrideSubsystem && "subsystem-snippet.xml".equals(file.getName())) {
                    this.log.debugf("Found packaged subsystem snippet: [%s]", (Object)file.getAbsolutePath());
                    options.subsystem(file.toURI().toURL());
                }
                if (overrideSocketBinding || !"socket-binding-snippet.xml".equals(file.getName())) continue;
                this.log.debugf("Found packaged socket-binding snippet: [%s]", (Object)file.getAbsolutePath());
                options.socketBinding(file.toURI().toURL());
            }
        }
        return options;
    }

    public void register(RegisterModuleConfiguration options) throws Exception {
        new RegisterExtension().register(options);
    }

    private void validConfiguration(DeploymentConfiguration configuration) throws ExtensionDeploymentException {
        File jbossHome = configuration.getJbossHome();
        if (!(jbossHome.exists() && jbossHome.isDirectory() && jbossHome.canRead())) {
            throw new ExtensionDeploymentException("wildflyHome = " + jbossHome.getAbsolutePath() + " is not readable and existing directory");
        }
        if (!new File(jbossHome, "modules").isDirectory()) {
            throw new ExtensionDeploymentException("wildflyHome = " + jbossHome.getAbsolutePath() + " does not seem to point to AS7/WildFly installation dir");
        }
        this.targetServerConfigAbsolute = new File(configuration.getTargetServerConfig()).isAbsolute() ? new File(configuration.getTargetServerConfig()) : new File(jbossHome, configuration.getTargetServerConfig());
        if (!(this.targetServerConfigAbsolute.exists() && this.targetServerConfigAbsolute.isFile() && this.targetServerConfigAbsolute.canWrite())) {
            throw new ExtensionDeploymentException("targetServerConfig = " + configuration.getTargetServerConfig() + " is not writable and existing file. [targetserverConfig]" + "must be either absolute path or relative to [jbossHome]");
        }
        this.sourceServerConfigBackupAbsolute = new File(configuration.getSourceServerConfig()).isAbsolute() ? new File(configuration.getSourceServerConfig()) : new File(jbossHome, configuration.getSourceServerConfig());
        if (!(this.sourceServerConfigBackupAbsolute.getParentFile().exists() && this.targetServerConfigAbsolute.getParentFile().isDirectory() && this.targetServerConfigAbsolute.getParentFile().canWrite())) {
            throw new ExtensionDeploymentException("sourceServerConfig = " + configuration.getSourceServerConfig() + " 's parent directory does not exist or is writable." + "[sourceServerConfig] must be either absolute path or relative to [jbossHome]");
        }
        String modulesHome = configuration.getModulesHome();
        if (modulesHome == null) {
            File wfHome = Paths.get(jbossHome.getAbsolutePath(), "modules", "system", "layers", "base").toFile();
            if (!wfHome.exists()) {
                wfHome = Paths.get(jbossHome.getAbsolutePath(), "modules").toFile();
            }
            this.modulesHomeAbsolute = wfHome;
        } else {
            File modulesHomeFile = Paths.get(modulesHome, new String[0]).toFile();
            this.modulesHomeAbsolute = modulesHomeFile.isAbsolute() ? modulesHomeFile : Paths.get(jbossHome.getAbsolutePath(), modulesHome).toFile();
        }
        if (!(this.modulesHomeAbsolute.exists() && this.modulesHomeAbsolute.isDirectory() && this.modulesHomeAbsolute.canWrite())) {
            throw new ExtensionDeploymentException("modulesHome = " + modulesHome + " is not writable and existing directory. [modulesHome]" + "must be either absolute path or relative to [jbossHome]");
        }
    }
}

