/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.actions.email.registration;

import java.util.HashSet;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import org.hawkular.actions.api.log.MsgLogger;
import org.hawkular.actions.api.model.ActionPluginMessage;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.jboss.logging.Logger;

@Startup
@Singleton
public class RegistrationInit {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(RegistrationInit.class);
    private static final String ACTION_PLUGIN_REGISTER = "HawkularAlertsPluginsQueue";
    @Resource(mappedName="java:/HawkularBusConnectionFactory")
    private QueueConnectionFactory conFactory;
    private ConnectionContextFactory ccf;
    private ProducerConnectionContext pcc;

    @PostConstruct
    public void init() {
        try {
            this.ccf = new ConnectionContextFactory((ConnectionFactory)this.conFactory);
            this.pcc = this.ccf.createProducerConnectionContext(new Endpoint(Endpoint.Type.QUEUE, ACTION_PLUGIN_REGISTER));
            ActionPluginMessage apMsg = new ActionPluginMessage();
            apMsg.setOp("init");
            apMsg.setActionPlugin("email");
            HashSet<String> properties = new HashSet<String>();
            properties.add("to");
            properties.add("cc");
            properties.add("description");
            apMsg.setProperties(properties);
            MessageId mid = new MessageProcessor().send(this.pcc, (BasicMessage)apMsg);
            this.msgLog.infoPluginRegistration("email", mid.toString());
        }
        catch (JMSException e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            this.msgLog.errorCannotSendMessage("email", e.getMessage());
        }
    }
}

