/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.actions.email.listener;

import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.MessageListener;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.hawkular.actions.api.log.MsgLogger;
import org.hawkular.actions.api.model.ActionMessage;
import org.hawkular.actions.email.listener.EmailListener;
import org.hawkular.actions.email.template.EmailTemplate;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.condition.Alert;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularAlertsActionsTopic"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="actionPlugin like 'email'")})
public class EmailListener
extends BasicMessageListener<ActionMessage> {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(EmailListener.class);
    private final EmailTemplate emailTemplate = new EmailTemplate();
    @Resource(mappedName="java:jboss/mail/Default")
    Session mailSession;

    protected void onBasicMessage(ActionMessage msg) {
        try {
            this.log.debug((Object)("Action received for plugin [email], msg = " + msg.toString()));
            Message message = this.createMimeMessage(msg);
            Transport.send((Message)message);
        }
        catch (Exception e) {
            this.msgLog.errorCannotSendMessage("email", e.getLocalizedMessage());
        }
    }

    protected Message createMimeMessage(ActionMessage msg) throws Exception {
        Map body;
        String subject;
        String ccs;
        String to;
        HawkularMimeMessage email = new HawkularMimeMessage(this, this.mailSession);
        Map props = msg.getProperties();
        Map defaultProps = msg.getDefaultProperties();
        String message = msg.getMessage();
        Alert alert = msg.getAlert() != null ? (Alert)JsonUtil.fromJson((String)msg.getAlert(), Alert.class) : null;
        Alert.Status status = alert != null && alert.getStatus() != null ? alert.getStatus() : Alert.Status.OPEN;
        String from = this.getProp(props, defaultProps, "from." + status.name().toLowerCase());
        from = from == null ? this.getProp(props, defaultProps, "from") : from;
        from = from == null ? "noreply@hawkular.org" : from;
        String fromName = this.getProp(props, defaultProps, "from-name." + status.name().toLowerCase());
        fromName = fromName == null ? this.getProp(props, defaultProps, "from-name") : fromName;
        fromName = fromName == null ? "Hawkular" : fromName;
        email.setFrom((Address)new InternetAddress(from, fromName));
        if (alert != null && alert.getStatus() != null) {
            if (alert.getStatus().equals((Object)Alert.Status.OPEN)) {
                email.setSentDate(new Date(alert.getCtime()));
            } else if (alert.getStatus().equals((Object)Alert.Status.ACKNOWLEDGED)) {
                email.setSentDate(new Date(alert.getAckTime()));
            } else {
                email.setSentDate(new Date(alert.getResolvedTime()));
            }
        }
        if (alert != null) {
            email.addHeader("Message-ID", alert.getAlertId());
            if (alert.getStatus() != null && !alert.getStatus().equals((Object)Alert.Status.OPEN)) {
                email.addHeader("in-reply-to", alert.getAlertId());
            }
        }
        String string = to = (to = this.getProp(props, defaultProps, "to." + status.name().toLowerCase())) == null ? this.getProp(props, defaultProps, "to") : to;
        if (to != null) {
            InternetAddress toAddress = new InternetAddress(to);
            email.addRecipient(Message.RecipientType.TO, (Address)toAddress);
        }
        String string2 = ccs = (ccs = this.getProp(props, defaultProps, "cc." + status.name().toLowerCase())) == null ? this.getProp(props, defaultProps, "cc") : ccs;
        if (ccs != null) {
            String[] multipleCc;
            for (String cc : multipleCc = ccs.split(",")) {
                InternetAddress toAddress = new InternetAddress(cc);
                email.addRecipient(Message.RecipientType.CC, (Address)toAddress);
            }
        }
        if ((subject = this.emailTemplate.subject(alert)) != null) {
            email.setSubject(subject);
        }
        if ((body = this.emailTemplate.body(props, defaultProps, message, alert)) != null && body.get("plain") != null && body.get("html") != null) {
            MimeBodyPart text = new MimeBodyPart();
            text.setContent(body.get("plain"), "text/plain");
            MimeBodyPart html = new MimeBodyPart();
            html.setContent(body.get("html"), "text/html");
            MimeMultipart multipart = new MimeMultipart("alternative");
            multipart.addBodyPart((BodyPart)html);
            multipart.addBodyPart((BodyPart)text);
            email.setContent((Multipart)multipart);
        }
        return email;
    }

    private String getProp(Map<String, String> props, Map<String, String> defaultProps, String prop) {
        if (props != null && props.get(prop) != null) {
            return props.get(prop);
        }
        if (defaultProps != null && defaultProps.get(prop) != null) {
            return defaultProps.get(prop);
        }
        return null;
    }
}

