/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.actions.email.template;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hawkular.actions.api.log.MsgLogger;
import org.hawkular.actions.email.template.EmailTemplate;
import org.hawkular.alerts.api.model.condition.Alert;
import org.hawkular.alerts.api.model.condition.AvailabilityCondition;
import org.hawkular.alerts.api.model.condition.AvailabilityConditionEval;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.CompareConditionEval;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.condition.ExternalCondition;
import org.hawkular.alerts.api.model.condition.ExternalConditionEval;
import org.hawkular.alerts.api.model.condition.StringCondition;
import org.hawkular.alerts.api.model.condition.StringConditionEval;
import org.hawkular.alerts.api.model.condition.ThresholdCondition;
import org.hawkular.alerts.api.model.condition.ThresholdConditionEval;
import org.hawkular.alerts.api.model.condition.ThresholdRangeCondition;
import org.hawkular.alerts.api.model.condition.ThresholdRangeConditionEval;
import org.jboss.logging.Logger;

public class EmailTemplate {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(EmailTemplate.class);
    public static final String DEFAULT_TEMPLATE_PLAIN = "template.plain.default.ftl";
    public static final String DEFAULT_TEMPLATE_HTML = "template.html.default.ftl";
    public static final Locale DEFAULT_LOCALE = new Locale("en", "US");
    Configuration ftlCfg = new Configuration();
    Template ftlTemplate;
    Template ftlTemplatePlain;
    Template ftlTemplateHtml;

    public EmailTemplate() {
        try {
            File fileDir;
            String templatesDir = System.getenv("HAWKULAR_ALERTS_TEMPLATES");
            templatesDir = templatesDir == null ? System.getProperty("hawkular.alerts.templates") : templatesDir;
            boolean templatesFromDir = false;
            if (templatesDir != null && (fileDir = new File(templatesDir)).exists()) {
                this.ftlCfg.setDirectoryForTemplateLoading(fileDir);
                templatesFromDir = true;
            }
            if (!templatesFromDir) {
                this.ftlCfg.setClassForTemplateLoading(this.getClass(), "/");
            }
            this.ftlTemplatePlain = this.ftlCfg.getTemplate(DEFAULT_TEMPLATE_PLAIN, DEFAULT_LOCALE);
            this.ftlTemplateHtml = this.ftlCfg.getTemplate(DEFAULT_TEMPLATE_HTML, DEFAULT_LOCALE);
        }
        catch (IOException e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("Cannot initialize templates on email plugin: " + e.getMessage());
        }
    }

    public String subject(Alert alert) throws Exception {
        HashMap subjects = new HashMap();
        this.subjects(subjects, alert);
        return subjects.get("subject") != null ? (String)subjects.get("subject") : "Alert message";
    }

    public Map<String, String> body(Map<String, String> props, Map<String, String> defaultProps, String message, Alert alert) throws Exception {
        HashMap<String, String> processed = new HashMap<String, String>();
        if (message != null || alert != null) {
            String html;
            String plain;
            String templateLocale;
            if (alert == null && message == null) {
                String plain2;
                String html2 = plain2 = "Message received without data at " + System.currentTimeMillis();
                processed.put("plain", plain2);
                processed.put("html", html2);
                this.msgLog.warnMessageReceivedWithoutPayload("email");
                return processed;
            }
            HashMap<String, Object> templateData = new HashMap<String, Object>();
            if (alert != null) {
                templateData.put("alert", alert);
            } else if (message != null) {
                templateData.put("message", message);
            }
            this.subjects(templateData, alert);
            String templateHawkularUrl = this.getProp(props, defaultProps, "template.hawkular.url");
            if (templateHawkularUrl == null) {
                templateHawkularUrl = System.getenv("HAWKULAR_BASE_URL");
            }
            templateData.put("url", templateHawkularUrl);
            if (alert != null && alert.getStatus() != null) {
                Alert.Status status = alert.getStatus();
                templateData.put("status", status.name());
            }
            if ((templateLocale = this.getProp(props, defaultProps, "template.locale")) != null) {
                plain = this.getProp(props, defaultProps, "template.plain." + templateLocale);
                html = this.getProp(props, defaultProps, "template.html." + templateLocale);
            } else {
                plain = this.getProp(props, defaultProps, "template.plain");
                html = this.getProp(props, defaultProps, "template.html");
            }
            int numConditions = this.getConditionsSize(alert);
            templateData.put("numConditions", numConditions);
            if (numConditions == 1) {
                this.averageAndThreshold(templateData, alert);
            } else if (numConditions > 1) {
                List condDescs = this.getConditionDescription(alert);
                templateData.put("condDescs", condDescs);
            }
            StringWriter writerPlain = new StringWriter();
            StringWriter writerHtml = new StringWriter();
            if (plain != null) {
                this.ftlTemplate = Template.getPlainTextTemplate((String)"plainTemplate", (String)plain, (Configuration)this.ftlCfg);
                this.ftlTemplate.process(templateData, (Writer)writerPlain);
            } else {
                this.ftlTemplatePlain.process(templateData, (Writer)writerPlain);
            }
            if (html != null) {
                this.ftlTemplate = Template.getPlainTextTemplate((String)"htmlTemplate", (String)html, (Configuration)this.ftlCfg);
                this.ftlTemplate.process(templateData, (Writer)writerHtml);
            } else {
                this.ftlTemplateHtml.process(templateData, (Writer)writerHtml);
            }
            writerPlain.flush();
            writerPlain.close();
            writerHtml.flush();
            writerHtml.close();
            processed.put("plain", writerPlain.toString());
            processed.put("html", writerHtml.toString());
        }
        return processed;
    }

    private void subjects(Map<String, Object> props, Alert alert) {
        String subject;
        String plainSubject;
        String htmlSubject;
        if (props == null) {
            return;
        }
        if (alert == null) {
            return;
        }
        if (alert.getTrigger() == null) {
            plainSubject = htmlSubject = this.getStateSubject(alert);
            subject = htmlSubject;
        } else {
            int numConditions = this.getConditionsSize(alert);
            if (numConditions == 0) {
                plainSubject = htmlSubject = this.getStateSubject(alert);
                subject = htmlSubject;
            } else if (numConditions == 1) {
                String description;
                ThresholdCondition rCondition;
                Condition.Type type = this.getFirstConditionType(alert);
                Condition condition = this.getFirstCondition(alert);
                plainSubject = htmlSubject = this.getStateSubject(alert);
                subject = htmlSubject;
                if (type != null && type.equals((Object)Condition.Type.AVAILABILITY)) {
                    plainSubject = "Server " + alert.getTrigger().getName() + " is";
                    htmlSubject = "Server is ";
                    AvailabilityCondition aCondition = (AvailabilityCondition)condition;
                    subject = subject + ": " + alert.getTrigger().getName() + " is";
                    if (alert.getStatus().equals((Object)Alert.Status.RESOLVED) && alert.getResolvedEvalSets() != null) {
                        rCondition = (AvailabilityCondition)this.getFirstResolvedCondition(alert);
                        description = this.oneCondAvailabilityDescription((AvailabilityCondition)rCondition);
                    } else {
                        description = this.oneCondAvailabilityDescription(aCondition);
                    }
                    subject = subject + " " + description;
                    plainSubject = plainSubject + " " + description;
                    htmlSubject = htmlSubject + " " + description;
                }
                if (type != null && type.equals((Object)Condition.Type.THRESHOLD)) {
                    ThresholdCondition tCondition = (ThresholdCondition)condition;
                    subject = subject + ": " + alert.getTrigger().getName() + " has response time";
                    plainSubject = "Response time";
                    if (alert.getStatus().equals((Object)Alert.Status.RESOLVED) && alert.getResolvedEvalSets() != null) {
                        rCondition = (ThresholdCondition)this.getFirstResolvedCondition(alert);
                        description = this.oneCondResponseTimeDescription(rCondition);
                    } else {
                        description = this.oneCondResponseTimeDescription(tCondition);
                    }
                    subject = subject + " " + description;
                    htmlSubject = plainSubject = plainSubject + " " + description;
                    plainSubject = plainSubject + " for " + alert.getTrigger().getName();
                }
            } else {
                subject = this.getStateSubject(alert) + " for " + alert.getTrigger().getName();
                plainSubject = "Alert for " + alert.getTrigger().getName();
                htmlSubject = "Alert for";
            }
        }
        props.put("subject", subject);
        props.put("plainSubject", plainSubject);
        props.put("htmlSubject", htmlSubject);
    }

    private String oneCondAvailabilityDescription(AvailabilityCondition cond) {
        if (cond.getOperator().equals((Object)AvailabilityCondition.Operator.UP)) {
            return "up";
        }
        if (cond.getOperator().equals((Object)AvailabilityCondition.Operator.NOT_UP)) {
            return "not up";
        }
        if (cond.getOperator().equals((Object)AvailabilityCondition.Operator.DOWN)) {
            return "down";
        }
        return "";
    }

    private String oneCondResponseTimeDescription(ThresholdCondition cond) {
        if (cond.getOperator().equals((Object)ThresholdCondition.Operator.GT)) {
            return "greater than threshold";
        }
        if (cond.getOperator().equals((Object)ThresholdCondition.Operator.GTE)) {
            return "greater or equal than threshold";
        }
        if (cond.getOperator().equals((Object)ThresholdCondition.Operator.LT)) {
            return "less than threshold";
        }
        if (cond.getOperator().equals((Object)ThresholdCondition.Operator.LTE)) {
            return "less or equal than threshold";
        }
        return "";
    }

    private String mixDescription(Condition cond) {
        String desc = "";
        if (cond instanceof ThresholdCondition) {
            desc = desc + cond.getDataId() + " is ";
            ThresholdCondition.Operator operator = ((ThresholdCondition)cond).getOperator();
            if (operator.equals((Object)ThresholdCondition.Operator.LT)) {
                desc = desc + "less than ";
            } else if (operator.equals((Object)ThresholdCondition.Operator.LTE)) {
                desc = desc + "less or equals than ";
            } else if (operator.equals((Object)ThresholdCondition.Operator.GT)) {
                desc = desc + "greater than ";
            } else if (operator.equals((Object)ThresholdCondition.Operator.LT)) {
                desc = desc + "greater or equals than ";
            }
            desc = desc + ((ThresholdCondition)cond).getThreshold();
        } else if (cond instanceof AvailabilityCondition) {
            desc = desc + cond.getDataId() + " is ";
            AvailabilityCondition.Operator operator = ((AvailabilityCondition)cond).getOperator();
            if (operator.equals((Object)AvailabilityCondition.Operator.DOWN)) {
                desc = desc + "down ";
            } else if (operator.equals((Object)AvailabilityCondition.Operator.NOT_UP)) {
                desc = desc + "not up";
            } else if (operator.equals((Object)AvailabilityCondition.Operator.UP)) {
                desc = desc + "up";
            }
        } else if (cond instanceof ThresholdRangeCondition) {
            desc = desc + cond.getDataId() + " ";
            desc = ((ThresholdRangeCondition)cond).isInRange() ? desc + "in range " : desc + "out of range ";
            ThresholdRangeCondition.Operator operatorLow = ((ThresholdRangeCondition)cond).getOperatorLow();
            ThresholdRangeCondition.Operator operatorHigh = ((ThresholdRangeCondition)cond).getOperatorHigh();
            desc = operatorLow.equals((Object)ThresholdRangeCondition.Operator.INCLUSIVE) ? desc + "[ " : desc + "( ";
            desc = desc + ((ThresholdRangeCondition)cond).getThresholdLow();
            desc = desc + ", ";
            desc = desc + ((ThresholdRangeCondition)cond).getThresholdHigh();
            desc = operatorHigh.equals((Object)ThresholdRangeCondition.Operator.INCLUSIVE) ? desc + " ]" : desc + " )";
        } else if (cond instanceof StringCondition) {
            desc = desc + cond.getDataId() + " ";
            StringCondition.Operator operator = ((StringCondition)cond).getOperator();
            if (operator.equals((Object)StringCondition.Operator.STARTS_WITH)) {
                desc = desc + "starts with ";
            } else if (operator.equals((Object)StringCondition.Operator.CONTAINS)) {
                desc = desc + "contains ";
            } else if (operator.equals((Object)StringCondition.Operator.ENDS_WITH)) {
                desc = desc + "ends with ";
            } else if (operator.equals((Object)StringCondition.Operator.EQUAL)) {
                desc = desc + "is equal to ";
            } else if (operator.equals((Object)StringCondition.Operator.NOT_EQUAL)) {
                desc = desc + "is not equal to ";
            } else if (operator.equals((Object)StringCondition.Operator.MATCH)) {
                desc = desc + "matches to ";
            }
            desc = desc + ((StringCondition)cond).getPattern();
            if (((StringCondition)cond).isIgnoreCase()) {
                desc = desc + " (ignore case) ";
            }
        } else if (cond instanceof CompareCondition) {
            desc = desc + cond.getDataId() + " ";
            CompareCondition.Operator operator = ((CompareCondition)cond).getOperator();
            if (operator.equals((Object)CompareCondition.Operator.LT)) {
                desc = desc + "less than ";
            } else if (operator.equals((Object)CompareCondition.Operator.LTE)) {
                desc = desc + "less or equals than ";
            } else if (operator.equals((Object)CompareCondition.Operator.GT)) {
                desc = desc + "greater than ";
            } else if (operator.equals((Object)CompareCondition.Operator.GTE)) {
                desc = desc + "greater or equals than ";
            }
            desc = ((CompareCondition)cond).getData2Multiplier() != 1.0 ? desc + "( " + ((CompareCondition)cond).getData2Id() + " * " + ((CompareCondition)cond).getData2Multiplier() + " )" : desc + ((CompareCondition)cond).getData2Id();
        } else if (cond instanceof ExternalCondition) {
            desc = desc + cond.getDataId() + " with external expression " + ((ExternalCondition)cond).getExpression();
        }
        return desc;
    }

    private String getStateSubject(Alert alert) {
        if (alert != null && alert.getStatus() != null) {
            return "Alert [" + alert.getStatus().name().toLowerCase() + "] message";
        }
        return "Alert message";
    }

    private Condition.Type getFirstConditionType(Alert alert) {
        if (alert != null && alert.getEvalSets() != null && alert.getEvalSets().size() > 0 && alert.getEvalSets().get(0) != null && ((Set)alert.getEvalSets().get(0)).size() > 0) {
            ConditionEval conditionEval = (ConditionEval)((Set)alert.getEvalSets().get(0)).iterator().next();
            return conditionEval.getType();
        }
        return null;
    }

    private int getConditionsSize(Alert alert) {
        if (alert != null && alert.getEvalSets() != null && alert.getEvalSets().size() > 0) {
            return ((Set)alert.getEvalSets().get(0)).size();
        }
        return 0;
    }

    private Condition getFirstCondition(Alert alert) {
        if (alert == null || alert.getEvalSets() == null || alert.getEvalSets().size() == 0 || alert.getStatus() == null) {
            return null;
        }
        if (alert.getEvalSets().get(0) != null && ((Set)alert.getEvalSets().get(0)).size() > 0) {
            ConditionEval conditionEval = (ConditionEval)((Set)alert.getEvalSets().get(0)).iterator().next();
            if (conditionEval instanceof AvailabilityConditionEval) {
                return ((AvailabilityConditionEval)conditionEval).getCondition();
            }
            if (conditionEval instanceof ThresholdConditionEval) {
                return ((ThresholdConditionEval)conditionEval).getCondition();
            }
        }
        return null;
    }

    private Condition getFirstResolvedCondition(Alert alert) {
        if (alert == null || alert.getResolvedEvalSets() == null || alert.getResolvedEvalSets().size() == 0 || alert.getStatus() == null) {
            return null;
        }
        if (alert.getResolvedEvalSets().get(0) != null && ((Set)alert.getResolvedEvalSets().get(0)).size() > 0) {
            ConditionEval conditionEval = (ConditionEval)((Set)alert.getResolvedEvalSets().get(0)).iterator().next();
            if (conditionEval instanceof AvailabilityConditionEval) {
                return ((AvailabilityConditionEval)conditionEval).getCondition();
            }
            if (conditionEval instanceof ThresholdConditionEval) {
                return ((ThresholdConditionEval)conditionEval).getCondition();
            }
        }
        return null;
    }

    private void averageAndThreshold(Map<String, Object> props, Alert alert) {
        if (props != null && alert != null) {
            double totalTime = 0.0;
            int countTime = 0;
            for (Set setEval : alert.getEvalSets()) {
                for (ConditionEval cEval : setEval) {
                    if (!(cEval instanceof ThresholdConditionEval)) continue;
                    totalTime += ((ThresholdConditionEval)cEval).getValue().doubleValue();
                    ++countTime;
                }
            }
            double average = totalTime / (double)countTime;
            props.put("average", Double.toString(average));
            props.put("condition", this.getFirstCondition(alert));
        }
    }

    private String getProp(Map<String, String> props, Map<String, String> defaultProps, String prop) {
        if (props != null && props.get(prop) != null) {
            return props.get(prop);
        }
        if (defaultProps != null && defaultProps.get(prop) != null) {
            return defaultProps.get(prop);
        }
        return null;
    }

    private List<ConditionDesc> getConditionDescription(Alert alert) {
        List evalsSets;
        ArrayList<ConditionDesc> descs = new ArrayList<ConditionDesc>();
        if (alert != null && alert.getEvalSets() != null && (evalsSets = alert.getEvalSets()).size() > 0) {
            Set setEval = (Set)evalsSets.get(0);
            for (ConditionEval eval : setEval) {
                ConditionDesc desc = new ConditionDesc();
                desc.type = eval.getType().name();
                if (eval.getType().equals((Object)Condition.Type.THRESHOLD)) {
                    desc.description = this.mixDescription((Condition)((ThresholdConditionEval)eval).getCondition());
                } else if (eval.getType().equals((Object)Condition.Type.AVAILABILITY)) {
                    desc.description = this.mixDescription((Condition)((AvailabilityConditionEval)eval).getCondition());
                } else if (eval.getType().equals((Object)Condition.Type.RANGE)) {
                    desc.description = this.mixDescription((Condition)((ThresholdRangeConditionEval)eval).getCondition());
                } else if (eval.getType().equals((Object)Condition.Type.COMPARE)) {
                    desc.description = this.mixDescription((Condition)((CompareConditionEval)eval).getCondition());
                } else if (eval.getType().equals((Object)Condition.Type.STRING)) {
                    desc.description = this.mixDescription((Condition)((StringConditionEval)eval).getCondition());
                } else if (eval.getType().equals((Object)Condition.Type.EXTERNAL)) {
                    desc.description = this.mixDescription((Condition)((ExternalConditionEval)eval).getCondition());
                }
                descs.add(desc);
            }
        }
        return descs;
    }
}

