/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.aerogear;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hawkular.alerts.actions.api.ActionMessage;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.api.ActionPluginSender;
import org.hawkular.alerts.actions.api.ActionResponseMessage;
import org.hawkular.alerts.actions.api.MsgLogger;
import org.hawkular.alerts.actions.api.Plugin;
import org.hawkular.alerts.actions.api.Sender;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.model.event.Alert;
import org.hawkular.alerts.api.model.event.Event;
import org.jboss.aerogear.unifiedpush.DefaultPushSender;
import org.jboss.aerogear.unifiedpush.PushSender;
import org.jboss.aerogear.unifiedpush.message.UnifiedMessage;

@Plugin(name="aerogear")
public class AerogearPlugin
implements ActionPluginListener {
    static final String ROOT_SERVER_URL_PROPERTY = "org.hawkular.alerts.actions.aerogear.root.server.url";
    static final String ROOT_SERVER_URL = System.getProperty("org.hawkular.alerts.actions.aerogear.root.server.url");
    static final String APPLICATION_ID_PROPERTY = "org.hawkular.alerts.actions.aerogear.application.id";
    static final String APPLICATION_ID = System.getProperty("org.hawkular.alerts.actions.aerogear.application.id");
    static final String MASTER_SECRET_PROPERTY = "org.hawkular.alerts.actions.aerogear.master.secret";
    static final String MASTER_SECRET = System.getProperty("org.hawkular.alerts.actions.aerogear.master.secret");
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    Map<String, String> defaultProperties = new HashMap<String, String>();
    PushSender pushSender;
    @Sender
    ActionPluginSender sender;
    private static final String MESSAGE_PROCESSED = "PROCESSED";
    private static final String MESSAGE_FAILED = "FAILED";

    public AerogearPlugin() {
        this.defaultProperties.put("alias", "Default aerogear alias");
        this.defaultProperties.put("description", "Default aerogear description");
        this.setup();
    }

    public Set<String> getProperties() {
        return this.defaultProperties.keySet();
    }

    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    public void process(ActionMessage msg) throws Exception {
        if (this.pushSender == null) {
            this.msgLog.errorCannotProcessMessage("aerogear", "Plugin is not started");
            return;
        }
        try {
            String alias;
            UnifiedMessage.MessageBuilder alert = UnifiedMessage.withMessage().alert(this.prepareMessage(msg));
            if (msg.getAction().getProperties() != null && !this.isBlank(alias = (String)msg.getAction().getProperties().get("alias"))) {
                alert.config().criteria().aliases(new String[]{alias});
            }
            UnifiedMessage unifiedMessage = alert.build();
            this.pushSender.send(unifiedMessage);
            this.msgLog.infoActionReceived("aerogear", msg.toString());
            Action successAction = msg.getAction();
            successAction.setResult(MESSAGE_PROCESSED);
            this.sendResult(successAction);
        }
        catch (Exception e) {
            this.msgLog.errorCannotProcessMessage("aerogear", e.getMessage());
            Action failedAction = msg.getAction();
            failedAction.setResult(MESSAGE_FAILED);
            this.sendResult(failedAction);
        }
    }

    void setup() {
        if (this.isBlank(ROOT_SERVER_URL) || this.isBlank(APPLICATION_ID) || this.isBlank(MASTER_SECRET)) {
            String msg = "Configure org.hawkular.alerts.actions.aerogear.root.server.url, org.hawkular.alerts.actions.aerogear.application.id and org.hawkular.alerts.actions.aerogear.master.secret";
            this.msgLog.errorCannotBeStarted("aerogear", msg);
            return;
        }
        try {
            this.pushSender = DefaultPushSender.withRootServerURL((String)ROOT_SERVER_URL).pushApplicationId(APPLICATION_ID).masterSecret(MASTER_SECRET).build();
        }
        catch (Exception e) {
            this.msgLog.errorCannotBeStarted("aerogear", e.getLocalizedMessage());
        }
    }

    private boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }

    private String prepareMessage(ActionMessage msg) {
        Event event;
        String preparedMsg = null;
        Event event2 = event = msg.getAction() != null ? msg.getAction().getEvent() : null;
        if (event != null) {
            if (event instanceof Alert) {
                Alert alert = (Alert)event;
                preparedMsg = "Alert : " + alert.getTriggerId() + " at " + alert.getCtime() + " -- Severity: " + alert.getSeverity().toString();
            } else {
                preparedMsg = "Event [" + event.getCategory() + "] " + event.getText() + " at " + event.getCtime();
            }
        } else {
            preparedMsg = "Message received without data at " + System.currentTimeMillis();
            this.msgLog.warnMessageReceivedWithoutPayload("aerogear");
        }
        return preparedMsg;
    }

    private void sendResult(Action action) {
        if (this.sender == null) {
            throw new IllegalStateException("ActionPluginSender is not present in the plugin");
        }
        if (action == null) {
            throw new IllegalStateException("Action to update result must be not null");
        }
        ActionResponseMessage newMessage = this.sender.createMessage(ActionResponseMessage.Operation.RESULT);
        newMessage.getPayload().put("action", JsonUtil.toJson((Object)action));
        try {
            this.sender.send(newMessage);
        }
        catch (Exception e) {
            this.msgLog.error((Object)"Error sending ActionResponseMessage", (Throwable)e);
        }
    }
}

