/*
 * Copyright 2015 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.hawkular.alerts.actions.api.model;

import java.util.Map;
import java.util.Set;

import org.hawkular.bus.common.BasicMessage;

import com.fasterxml.jackson.annotation.JsonInclude;

/**
 * An action plugin registration message.
 * i.e. sms, snmp, email
 *
 * This message is generated by the action plugin at registration phase.
 * It helps to centralize into the alerts engine how many types of plugins are available.
 *
 * "op" parameter define the operation (register a plugin, re-register a plugin).
 * Current values are:
 * "init" : register and initializes a plugin
 *
 * @author Jay Shaughnessy
 * @author Lucas Ponce
 */
public class ActionPluginMessage extends BasicMessage {

    @JsonInclude
    String op;

    @JsonInclude
    String actionPlugin;

    @JsonInclude
    Set<String> properties;

    @JsonInclude
    Map<String, String> defaultProperties;

    public ActionPluginMessage() { }

    public String getActionPlugin() {
        return actionPlugin;
    }

    public void setActionPlugin(String actionPlugin) {
        this.actionPlugin = actionPlugin;
    }

    public String getOp() {
        return op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public Set<String> getProperties() {
        return properties;
    }

    public void setProperties(Set<String> properties) {
        this.properties = properties;
    }

    public Map<String, String> getDefaultProperties() {
        return defaultProperties;
    }

    public void setDefaultProperties(Map<String, String> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ActionPluginMessage that = (ActionPluginMessage) o;

        if (op != null ? !op.equals(that.op) : that.op != null) return false;
        if (actionPlugin != null ? !actionPlugin.equals(that.actionPlugin) : that.actionPlugin != null) return false;
        if (properties != null ? !properties.equals(that.properties) : that.properties != null) return false;
        return !(defaultProperties != null ? !defaultProperties.equals(that.defaultProperties) :
                that.defaultProperties != null);

    }

    @Override
    public int hashCode() {
        int result = op != null ? op.hashCode() : 0;
        result = 31 * result + (actionPlugin != null ? actionPlugin.hashCode() : 0);
        result = 31 * result + (properties != null ? properties.hashCode() : 0);
        result = 31 * result + (defaultProperties != null ? defaultProperties.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ActionPluginMessage{" +
                "op='" + op + '\'' +
                ", actionPlugin='" + actionPlugin + '\'' +
                ", properties=" + properties +
                ", defaultProperties=" + defaultProperties +
                '}';
    }
}
