/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.bus;

import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hawkular.alerts.actions.api.ActionPlugin;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.jboss.vfs.VirtualFile;

public class ActionPlugins {
    private static ActionPlugins instance;
    private Map<String, ActionPluginListener> plugins;

    public static synchronized Map<String, ActionPluginListener> getPlugins() {
        if (instance == null) {
            instance = new ActionPlugins();
        }
        return Collections.unmodifiableMap(ActionPlugins.instance.plugins);
    }

    private ActionPlugins() {
        try {
            this.plugins = new HashMap<String, ActionPluginListener>();
            URL webInfUrl = this.getWebInfUrl();
            List<Class> pluginClasses = this.findAnnotationInClasses(webInfUrl, ActionPlugin.class);
            for (Class pluginClass : pluginClasses) {
                ActionPlugin actionPlugin = pluginClass.getDeclaredAnnotation(ActionPlugin.class);
                if (!(actionPlugin instanceof ActionPlugin)) continue;
                String name = actionPlugin.name();
                Object newInstance = pluginClass.newInstance();
                if (newInstance instanceof ActionPluginListener) {
                    ActionPluginListener pluginInstance = (ActionPluginListener)newInstance;
                    this.plugins.put(name, pluginInstance);
                    continue;
                }
                throw new IllegalStateException("Plugin [" + name + "] is not instance of " + "ActionPluginListener");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private URL getWebInfUrl() throws Exception {
        Enumeration<URL> allUrls = Thread.currentThread().getContextClassLoader().getResources("");
        while (allUrls != null && allUrls.hasMoreElements()) {
            URL url = allUrls.nextElement();
            if (!url.toExternalForm().contains("WEB-INF/classes")) continue;
            return url;
        }
        return null;
    }

    private List<Class> findAnnotationInClasses(URL url, Class annotation) throws Exception {
        if (url == null || annotation == null) {
            throw new IllegalArgumentException("url or annotation must be not null");
        }
        ArrayList<Class> plugins = new ArrayList<Class>();
        URLConnection conn = url.openConnection();
        VirtualFile root = (VirtualFile)conn.getContent();
        List children = root.getChildrenRecursively();
        for (VirtualFile vf : children) {
            String vfName = vf.toURI().toString();
            if (!vfName.endsWith(".class")) continue;
            int startName = vfName.indexOf("classes/") + 8;
            int stopName = vfName.indexOf(".class");
            String className = vfName.substring(startName, stopName).replace("/", ".");
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            if (!clazz.isAnnotationPresent(annotation)) continue;
            plugins.add(clazz);
        }
        return plugins;
    }
}

