/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.bus;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.MessageListener;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.api.PluginMessage;
import org.hawkular.alerts.actions.bus.ActionPlugins;
import org.hawkular.alerts.actions.bus.MsgLogger;
import org.hawkular.alerts.bus.api.BusPluginMessage;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularAlertsActionsTopic")})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class BusActionPluginListener
extends BasicMessageListener<BusPluginMessage> {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(BusActionPluginListener.class);

    protected void onBasicMessage(BusPluginMessage basicMessage) {
        if (ActionPlugins.getPlugins().isEmpty()) {
            this.msgLog.warnNoPluginsFound();
            return;
        }
        if (basicMessage == null || basicMessage.getAction() == null || basicMessage.getAction().getActionPlugin() == null) {
            this.msgLog.warnMessageReceivedWithoutPluginInfo();
            return;
        }
        String actionPlugin = basicMessage.getAction().getActionPlugin();
        ActionPluginListener plugin = ActionPlugins.getPlugins().get(actionPlugin);
        if (plugin == null) {
            this.log.debug((Object)("Received action [" + actionPlugin + "] but no ActionPluginListener found on this deployment"));
            return;
        }
        try {
            plugin.process((PluginMessage)basicMessage);
            this.msgLog.infoActionReceived(actionPlugin, basicMessage.getMessageId().getId());
            this.log.debug((Object)("Received payload: " + basicMessage.toJSON()));
        }
        catch (Exception e) {
            this.msgLog.error("Plugin [" + actionPlugin + "] processing error", e);
        }
    }
}

