/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.bus;

import java.io.IOException;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.bus.ActionPlugins;
import org.hawkular.alerts.actions.bus.MsgLogger;
import org.hawkular.alerts.bus.api.BusRegistrationMessage;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.jboss.logging.Logger;

@Startup
@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class BusActionPluginRegister {
    public static final int NUM_ATTEMPTS = 10;
    public static final int TIMEOUT = 2000;
    private static final String ACTION_PLUGIN_REGISTER = "HawkularAlertsPluginsQueue";
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(BusActionPluginRegister.class);
    @Resource(mappedName="java:/HawkularBusConnectionFactory")
    private QueueConnectionFactory conFactory;
    private ConnectionContextFactory ccf;
    private ProducerConnectionContext pcc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        int i = 10;
        while (this.ccf == null && i >= 0) {
            try {
                this.ccf = new ConnectionContextFactory((ConnectionFactory)this.conFactory);
            }
            catch (JMSException e) {
                this.msgLog.warnCannotConnectBroker(i, 2000, e.getMessage());
            }
            --i;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.ccf == null) {
            throw new IllegalStateException("Cannot connect to the broker.");
        }
        try {
            this.pcc = this.ccf.createProducerConnectionContext(new Endpoint(Endpoint.Type.QUEUE, ACTION_PLUGIN_REGISTER));
            Map<String, ActionPluginListener> plugins = ActionPlugins.getPlugins();
            for (String actionPlugin : plugins.keySet()) {
                ActionPluginListener actionPluginListener = plugins.get(actionPlugin);
                BusRegistrationMessage msg = new BusRegistrationMessage(actionPlugin, actionPluginListener.getProperties(), actionPluginListener.getDefaultProperties());
                MessageId mid = new MessageProcessor().send(this.pcc, (BasicMessage)msg);
                this.msgLog.infoPluginRegistration(actionPlugin, mid.toString());
            }
        }
        catch (JMSException e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            this.msgLog.errorCannotSendMessage(e.getMessage());
        }
        finally {
            if (this.pcc != null) {
                try {
                    this.pcc.close();
                    this.pcc = null;
                }
                catch (IOException iOException) {}
            }
            if (this.ccf != null) {
                try {
                    this.ccf.close();
                }
                catch (JMSException jMSException) {}
            }
        }
    }
}

