/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.bus;

import java.io.IOException;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hawkular.alerts.actions.api.ActionPluginSender;
import org.hawkular.alerts.actions.api.ActionResponseMessage;
import org.hawkular.alerts.actions.bus.BusActionPluginRegister;
import org.hawkular.alerts.actions.bus.MsgLogger;
import org.hawkular.alerts.bus.api.BusActionResponseMessage;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.jboss.logging.Logger;

public class BusActionPluginSender
implements ActionPluginSender {
    public static final int NUM_ATTEMPTS = 10;
    public static final int TIMEOUT = 2000;
    private static final String CONNECTION_FACTORY = "java:/HawkularBusConnectionFactory";
    private static final String ACTION_PLUGIN_REGISTER = "HawkularAlertsActionsResponseQueue";
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(BusActionPluginRegister.class);
    private String actionPlugin;
    private QueueConnectionFactory conFactory;
    private ThreadLocal<ConnectionContextFactory> ccf = new ThreadLocal();
    private ThreadLocal<ProducerConnectionContext> pcc = new ThreadLocal();

    public BusActionPluginSender(String actionPlugin) {
        this.actionPlugin = actionPlugin;
    }

    private void init() throws Exception {
        if (this.conFactory == null) {
            try {
                InitialContext ctx = new InitialContext();
                this.conFactory = (QueueConnectionFactory)ctx.lookup(CONNECTION_FACTORY);
            }
            catch (NamingException e) {
                throw new IllegalStateException("Cannot get context");
            }
        }
        if (this.ccf.get() == null) {
            for (int i = 10; this.ccf.get() == null && i >= 0; --i) {
                try {
                    this.ccf.set(new ConnectionContextFactory((ConnectionFactory)this.conFactory));
                    continue;
                }
                catch (JMSException e) {
                    this.msgLog.warnCannotConnectBroker(i, 2000, e.getMessage());
                    try {
                        Thread.sleep(2000L);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (this.ccf.get() == null) {
                throw new IllegalStateException("Cannot connect to the broker.");
            }
        }
        if (this.pcc.get() == null) {
            this.pcc.set(this.ccf.get().createProducerConnectionContext(new Endpoint(Endpoint.Type.QUEUE, ACTION_PLUGIN_REGISTER)));
        }
    }

    public void close() throws Exception {
        if (this.ccf != null) {
            try {
                this.ccf.get().close();
                this.ccf.remove();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ActionResponseMessage createMessage(ActionResponseMessage.Operation operation) {
        if (operation == null) {
            return new BusActionResponseMessage();
        }
        return new BusActionResponseMessage(operation);
    }

    public void send(ActionResponseMessage msg) throws Exception {
        if (!(msg instanceof BusActionResponseMessage)) {
            throw new IllegalArgumentException("ActionResponseMessage is not a BusActionResponseMessage instance");
        }
        this.init();
        try {
            if (this.pcc.get() == null) {
                this.pcc.set(this.ccf.get().createProducerConnectionContext(new Endpoint(Endpoint.Type.QUEUE, ACTION_PLUGIN_REGISTER)));
            }
            MessageId mid = new MessageProcessor().send(this.pcc.get(), (BasicMessage)((BusActionResponseMessage)msg));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Plugin [" + this.actionPlugin + "] has sent a response message: [" + mid.toString() + "]"));
            }
            if (this.pcc.get() != null) {
                try {
                    this.pcc.get().close();
                    this.pcc.remove();
                }
                catch (IOException iOException) {}
            }
        }
        catch (JMSException e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            this.msgLog.errorCannotSendMessage(e.getMessage());
        }
    }
}

