/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.bus;

import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.api.ActionPluginSender;
import org.hawkular.alerts.actions.api.Global;
import org.hawkular.alerts.actions.api.Plugin;
import org.hawkular.alerts.actions.api.Sender;
import org.hawkular.alerts.actions.bus.BusActionPluginSender;
import org.jboss.vfs.VirtualFile;

public class ActionPlugins {
    private static ActionPlugins instance;
    private Map<String, ActionPluginListener> plugins;
    private Set<String> globals;
    private Map<String, ActionPluginSender> senders;

    public static synchronized Map<String, ActionPluginListener> getPlugins() {
        if (instance == null) {
            instance = new ActionPlugins();
        }
        return Collections.unmodifiableMap(ActionPlugins.instance.plugins);
    }

    public static synchronized Set<String> getGlobals() {
        if (instance == null) {
            instance = new ActionPlugins();
        }
        return Collections.unmodifiableSet(ActionPlugins.instance.globals);
    }

    public static synchronized Map<String, ActionPluginSender> getSenders() {
        if (instance == null) {
            instance = new ActionPlugins();
        }
        return Collections.unmodifiableMap(ActionPlugins.instance.senders);
    }

    private ActionPlugins() {
        try {
            this.plugins = new HashMap<String, ActionPluginListener>();
            this.globals = new HashSet<String>();
            this.senders = new HashMap<String, ActionPluginSender>();
            URL webInfUrl = this.getWebInfUrl();
            List<Class> pluginClasses = this.findAnnotationInClasses(webInfUrl, Plugin.class);
            for (Class pluginClass : pluginClasses) {
                Plugin actionPlugin = pluginClass.getDeclaredAnnotation(Plugin.class);
                if (!(actionPlugin instanceof Plugin)) continue;
                String name = actionPlugin.name();
                Object newInstance = pluginClass.newInstance();
                if (newInstance instanceof ActionPluginListener) {
                    ActionPluginListener pluginInstance = (ActionPluginListener)newInstance;
                    this.injectActionPluginSender(name, pluginInstance);
                    this.plugins.put(name, pluginInstance);
                    if (!pluginClass.isAnnotationPresent(Global.class)) continue;
                    this.globals.add(name);
                    continue;
                }
                throw new IllegalStateException("Plugin [" + name + "] is not instance of " + "ActionPluginListener");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private URL getWebInfUrl() throws Exception {
        Enumeration<URL> allUrls = Thread.currentThread().getContextClassLoader().getResources("");
        while (allUrls != null && allUrls.hasMoreElements()) {
            URL url = allUrls.nextElement();
            if (!url.toExternalForm().contains("WEB-INF/classes")) continue;
            return url;
        }
        return null;
    }

    private List<Class> findAnnotationInClasses(URL url, Class annotation) throws Exception {
        if (url == null || annotation == null) {
            throw new IllegalArgumentException("url or annotation must be not null");
        }
        ArrayList<Class> plugins = new ArrayList<Class>();
        URLConnection conn = url.openConnection();
        VirtualFile root = (VirtualFile)conn.getContent();
        List children = root.getChildrenRecursively();
        for (VirtualFile vf : children) {
            String vfName = vf.toURI().toString();
            if (!vfName.endsWith(".class")) continue;
            int startName = vfName.indexOf("classes/") + 8;
            int stopName = vfName.indexOf(".class");
            String className = vfName.substring(startName, stopName).replace("/", ".");
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            if (!clazz.isAnnotationPresent(annotation)) continue;
            plugins.add(clazz);
        }
        return plugins;
    }

    private void injectActionPluginSender(String actionPlugin, ActionPluginListener pluginInstance) throws Exception {
        if (pluginInstance == null) {
            throw new IllegalArgumentException("pluginInstance must be not null");
        }
        Field[] fields = pluginInstance.getClass().getDeclaredFields();
        Field sender = null;
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Sender.class) || !field.getType().isAssignableFrom(ActionPluginSender.class)) continue;
            sender = field;
            break;
        }
        if (sender != null) {
            BusActionPluginSender busSender = new BusActionPluginSender(actionPlugin);
            sender.setAccessible(true);
            sender.set(pluginInstance, busSender);
            this.senders.put(actionPlugin, busSender);
        }
    }
}

