/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.bus;

import java.util.Collection;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.MessageListener;
import org.hawkular.alerts.actions.api.ActionMessage;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.api.ActionPluginSender;
import org.hawkular.alerts.actions.bus.ActionPlugins;
import org.hawkular.alerts.actions.bus.BusActionPluginSender;
import org.hawkular.alerts.actions.bus.MsgLogger;
import org.hawkular.alerts.bus.api.BusActionMessage;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularAlertsActionsTopic")})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class BusActionPluginListener
extends BasicMessageListener<BusActionMessage> {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(BusActionPluginListener.class);

    protected void onBasicMessage(BusActionMessage basicMessage) {
        if (ActionPlugins.getPlugins().isEmpty()) {
            this.msgLog.warnNoPluginsFound();
            return;
        }
        if (basicMessage == null || basicMessage.getAction() == null || basicMessage.getAction().getActionPlugin() == null) {
            this.msgLog.warnMessageReceivedWithoutPluginInfo();
            return;
        }
        String actionPlugin = basicMessage.getAction().getActionPlugin();
        ActionPluginListener plugin = ActionPlugins.getPlugins().get(actionPlugin);
        Set<String> globals = ActionPlugins.getGlobals();
        if (plugin == null && ActionPlugins.getGlobals().isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Received action [" + actionPlugin + "] " + "but no ActionPluginListener found on this deployment"));
            }
            return;
        }
        try {
            if (plugin != null) {
                plugin.process((ActionMessage)basicMessage);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Plugin [" + actionPlugin + "] has received a action message: [" + basicMessage.getMessageId().getId() + "] "));
                }
            }
            if (!globals.contains(actionPlugin)) {
                for (String global : globals) {
                    ActionPluginListener globalPlugin = ActionPlugins.getPlugins().get(global);
                    globalPlugin.process((ActionMessage)basicMessage);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Global plugin [" + global + "] has received a action message: [" + basicMessage.getMessageId().getId() + "]"));
                }
            }
        }
        catch (Exception e) {
            this.msgLog.error("Plugin [" + actionPlugin + "] processing error", e);
        }
    }

    @PreDestroy
    public void close() {
        Collection<ActionPluginSender> senders = ActionPlugins.getSenders().values();
        for (ActionPluginSender sender : senders) {
            if (!(sender instanceof BusActionPluginSender)) continue;
            try {
                ((BusActionPluginSender)sender).close();
            }
            catch (Exception e) {
                this.msgLog.error("Error closing sender [" + sender.toString() + "]", e);
            }
        }
    }
}

