/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.email;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hawkular.alerts.actions.api.ActionMessage;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.api.ActionPluginSender;
import org.hawkular.alerts.actions.api.ActionResponseMessage;
import org.hawkular.alerts.actions.api.MsgLogger;
import org.hawkular.alerts.actions.api.Plugin;
import org.hawkular.alerts.actions.api.Sender;
import org.hawkular.alerts.actions.email.EmailMimeMessage;
import org.hawkular.alerts.actions.email.EmailTemplate;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.model.event.Alert;
import org.jboss.logging.Logger;

@Plugin(name="email")
public class EmailPlugin
implements ActionPluginListener {
    public static final String PLUGIN_NAME = "email";
    public static final String MAIL_SESSION_PROPERTY = "org.hawkular.alerts.actions.email.session";
    public static final String MAIL_SESSION_OFFLINE = "org.hawkular.alerts.actions.email.session.offline";
    public static final String MESSAGE_ID = "Message-ID";
    public static final String IN_REPLY_TO = "in-reply-to";
    public static final String DEFAULT_FROM_PROPERTY = "org.hawkular.alerts.actions.email.default.from";
    public static final String DEFAULT_FROM = System.getProperty("org.hawkular.alerts.actions.email.default.from", "noreply@hawkular.org");
    public static final String DEFAULT_FROM_NAME_PROPERTY = "org.hawkular.alerts.actions.email.default.from-name";
    public static final String DEFAULT_FROM_NAME = System.getProperty("org.hawkular.alerts.actions.email.default.from-name", "Hawkular");
    public static final String HAWKULAR_BASE_URL = "HAWKULAR_BASE_URL";
    public static final String DEFAULT_HAWKULAR_BASE_URL = System.getenv("HAWKULAR_BASE_URL") == null ? "http://localhost:8080/" : System.getenv("HAWKULAR_BASE_URL");
    public static final String HAWKULAR_ALERTS_TEMPLATES = "HAWKULAR_ALERTS_TEMPLATES";
    public static final String HAWKULAR_ALERTS_TEMPLATES_PROPERY = "hawkular.alerts.templates";
    public static final String PROP_FROM = "from";
    public static final String PROP_FROM_NAME = "from-name";
    public static final String PROP_TO = "to";
    public static final String PROP_CC = "cc";
    public static final String PROP_TEMPLATE_HAWKULAR_URL = "template.hawkular.url";
    public static final String PROP_TEMPLATE_LOCALE = "template.locale";
    public static final String PROP_TEMPLATE_PLAIN = "template.plain";
    public static final String PROP_TEMPLATE_HTML = "template.html";
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(EmailPlugin.class);
    Map<String, String> defaultProperties = new HashMap();
    public static final String MAIL_SESSION = System.getProperty("org.hawkular.alerts.actions.email.session", "java:jboss/mail/Default");
    Session mailSession;
    EmailTemplate emailTemplate;
    @Sender
    ActionPluginSender sender;
    private static final String MESSAGE_PROCESSED = "PROCESSED";
    private static final String MESSAGE_FAILED = "FAILED";

    public EmailPlugin() {
        boolean offLine;
        this.defaultProperties.put(PROP_FROM, DEFAULT_FROM);
        this.defaultProperties.put(PROP_FROM_NAME, DEFAULT_FROM_NAME);
        this.defaultProperties.put(PROP_TO, "");
        this.defaultProperties.put(PROP_CC, "");
        this.defaultProperties.put(PROP_TEMPLATE_HAWKULAR_URL, DEFAULT_HAWKULAR_BASE_URL);
        this.defaultProperties.put(PROP_TEMPLATE_PLAIN, "");
        this.defaultProperties.put(PROP_TEMPLATE_HTML, "");
        this.emailTemplate = new EmailTemplate();
        boolean bl = offLine = System.getProperty(MAIL_SESSION_OFFLINE) != null;
        if (this.mailSession == null && !offLine) {
            this.initMailSession();
        }
    }

    private void initMailSession() {
        try {
            InitialContext ctx = new InitialContext();
            this.mailSession = (Session)ctx.lookup(MAIL_SESSION);
        }
        catch (NamingException e) {
            this.log.debug((Object)e);
            this.msgLog.errorCannotBeStarted(PLUGIN_NAME, e.getMessage());
        }
    }

    public Set<String> getProperties() {
        return this.defaultProperties.keySet();
    }

    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    private void sendResult(Action action) {
        if (this.sender == null) {
            throw new IllegalStateException("ActionPluginSender is not present in the plugin");
        }
        if (action == null) {
            throw new IllegalStateException("Action to update result must be not null");
        }
        ActionResponseMessage newMessage = this.sender.createMessage(ActionResponseMessage.Operation.RESULT);
        newMessage.getPayload().put("action", JsonUtil.toJson((Object)action));
        try {
            this.sender.send(newMessage);
        }
        catch (Exception e) {
            this.log.error((Object)"Error sending ActionResponseMessage", (Throwable)e);
        }
    }

    public void process(ActionMessage msg) throws Exception {
        if (msg == null || msg.getAction() == null) {
            this.msgLog.warnMessageReceivedWithoutPayload(PLUGIN_NAME);
        }
        try {
            Message message = this.createMimeMessage(msg);
            Transport.send((Message)message);
            this.msgLog.infoActionReceived(PLUGIN_NAME, msg.toString());
            Action successAction = msg.getAction();
            successAction.setResult(MESSAGE_PROCESSED);
            this.sendResult(successAction);
        }
        catch (Exception e) {
            this.msgLog.errorCannotProcessMessage(PLUGIN_NAME, e.getMessage());
            Action failedAction = msg.getAction();
            failedAction.setResult(MESSAGE_FAILED);
            this.sendResult(failedAction);
        }
    }

    protected Message createMimeMessage(ActionMessage msg) throws Exception {
        Map emailProcessed;
        String subject;
        String ccs;
        String to;
        EmailMimeMessage email = new EmailMimeMessage(this.mailSession);
        Map props = msg.getAction().getProperties();
        if (null == props || props.isEmpty()) {
            this.msgLog.warn((Object)"Properties empty on plugin email");
        }
        Alert event = msg.getAction() != null ? (Alert)msg.getAction().getEvent() : null;
        Alert alert = null != event && event instanceof Alert ? event : null;
        Alert.Status status = alert != null && alert.getStatus() != null ? alert.getStatus() : Alert.Status.OPEN;
        String statusStr = status.name().toLowerCase();
        String from = (String)props.get("from." + statusStr);
        from = from == null ? (String)props.get(PROP_FROM) : from;
        from = from == null ? DEFAULT_FROM : from;
        String fromName = (String)props.get("from-name." + statusStr);
        fromName = fromName == null ? (String)props.get(PROP_FROM_NAME) : fromName;
        fromName = fromName == null ? DEFAULT_FROM_NAME : fromName;
        email.setFrom((Address)new InternetAddress(from, fromName));
        if (alert != null && alert.getStatus() != null) {
            if (alert.getStatus().equals((Object)Alert.Status.OPEN)) {
                email.setSentDate(new Date(alert.getCtime()));
            } else if (alert.getStatus().equals((Object)Alert.Status.ACKNOWLEDGED)) {
                email.setSentDate(new Date(alert.getAckTime()));
            } else {
                email.setSentDate(new Date(alert.getResolvedTime()));
            }
        } else {
            email.setSentDate(new Date());
        }
        if (alert != null) {
            email.addHeader(MESSAGE_ID, alert.getAlertId());
            if (alert.getStatus() != null && !alert.getStatus().equals((Object)Alert.Status.OPEN)) {
                email.addHeader(IN_REPLY_TO, alert.getAlertId());
            }
        }
        String string = to = (to = (String)props.get("to." + statusStr)) == null ? (String)props.get(PROP_TO) : to;
        if (to != null && !to.isEmpty()) {
            InternetAddress toAddress = new InternetAddress(to);
            email.addRecipient(Message.RecipientType.TO, (Address)toAddress);
        }
        String string2 = ccs = (ccs = (String)props.get("cc." + statusStr)) == null ? (String)props.get(PROP_CC) : ccs;
        if (ccs != null && !ccs.isEmpty()) {
            String[] multipleCc;
            for (String cc : multipleCc = ccs.split(",")) {
                InternetAddress toAddress = new InternetAddress(cc);
                email.addRecipient(Message.RecipientType.CC, (Address)toAddress);
            }
        }
        if (null != (subject = (String)(emailProcessed = this.emailTemplate.processTemplate(msg)).get("emailSubject")) && !subject.isEmpty()) {
            email.setSubject(subject);
        } else {
            this.log.debugf("Subject not found processing email on message: %s", (Object)msg);
        }
        String plain = (String)emailProcessed.get("emailBodyPlain");
        String html = (String)emailProcessed.get("emailBodyHtml");
        if (plain != null && html != null) {
            MimeBodyPart text = new MimeBodyPart();
            text.setContent((Object)plain, "text/plain");
            MimeBodyPart rich = new MimeBodyPart();
            rich.setContent((Object)html, "text/html");
            MimeMultipart multipart = new MimeMultipart("alternative");
            multipart.addBodyPart((BodyPart)rich);
            multipart.addBodyPart((BodyPart)text);
            email.setContent((Multipart)multipart);
        }
        return email;
    }
}

