/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.file;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hawkular.alerts.actions.api.ActionMessage;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.api.ActionPluginSender;
import org.hawkular.alerts.actions.api.ActionResponseMessage;
import org.hawkular.alerts.actions.api.MsgLogger;
import org.hawkular.alerts.actions.api.Plugin;
import org.hawkular.alerts.actions.api.Sender;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.model.event.Event;

@Plugin(name="file")
public class FilePlugin
implements ActionPluginListener {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private Map<String, String> defaultProperties = new HashMap();
    private ObjectMapper objectMapper;
    @Sender
    ActionPluginSender sender;
    private static final String MESSAGE_PROCESSED = "PROCESSED";
    private static final String MESSAGE_FAILED = "FAILED";

    public FilePlugin() {
        this.defaultProperties.put("path", new File(System.getProperty("java.io.tmpdir"), "hawkular/alerts/actions/file").getAbsolutePath());
        this.objectMapper = new ObjectMapper();
    }

    public Set<String> getProperties() {
        return this.defaultProperties.keySet();
    }

    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ActionMessage msg) throws Exception {
        if (msg == null || msg.getAction() == null || msg.getAction().getEvent() == null) {
            this.msgLog.warnMessageReceivedWithoutPayload("file");
        }
        String path = msg.getAction().getProperties() != null ? (String)msg.getAction().getProperties().get("path") : null;
        path = path == null ? (String)this.defaultProperties.get("path") : path;
        path = path == null ? System.getProperty("user.home") : path;
        Event event = msg.getAction() != null ? msg.getAction().getEvent() : null;
        String fileName = event.getId() + "-timestamp-" + System.currentTimeMillis() + ".txt";
        try (BufferedWriter writer = null;){
            File alertFile;
            File pathFile = new File(path);
            if (!pathFile.exists()) {
                pathFile.mkdirs();
            }
            if (!(alertFile = new File(pathFile, fileName)).exists()) {
                alertFile.createNewFile();
            }
            writer = new BufferedWriter(new FileWriter(alertFile));
            String jsonEvent = this.objectMapper.writeValueAsString((Object)event);
            writer.write(jsonEvent);
            this.msgLog.infoActionReceived("file", msg.toString());
            Action successAction = msg.getAction();
            successAction.setResult(MESSAGE_PROCESSED);
            this.sendResult(successAction);
        }
    }

    private void sendResult(Action action) {
        if (this.sender == null) {
            throw new IllegalStateException("ActionPluginSender is not present in the plugin");
        }
        if (action == null) {
            throw new IllegalStateException("Action to update result must be not null");
        }
        ActionResponseMessage newMessage = this.sender.createMessage(ActionResponseMessage.Operation.RESULT);
        newMessage.getPayload().put("action", JsonUtil.toJson((Object)action));
        try {
            this.sender.send(newMessage);
        }
        catch (Exception e) {
            this.msgLog.error((Object)"Error sending ActionResponseMessage", (Throwable)e);
        }
    }
}

