/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.standalone;

import org.hawkular.alerts.actions.api.ActionPluginSender;
import org.hawkular.alerts.actions.api.ActionResponseMessage;
import org.hawkular.alerts.actions.standalone.MsgLogger;
import org.hawkular.alerts.actions.standalone.StandaloneActionPluginListener;
import org.hawkular.alerts.actions.standalone.StandaloneActionResponseMessage;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.services.ActionsService;
import org.jboss.logging.Logger;

public class StandaloneActionPluginSender
implements ActionPluginSender {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(StandaloneActionPluginListener.class);
    private ActionsService actions;

    public StandaloneActionPluginSender(ActionsService actions) {
        this.actions = actions;
    }

    public ActionResponseMessage createMessage(ActionResponseMessage.Operation operation) {
        if (operation == null) {
            return new StandaloneActionResponseMessage();
        }
        return new StandaloneActionResponseMessage(operation);
    }

    public void send(ActionResponseMessage msg) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Message received: " + msg));
        }
        if (msg != null && msg.getPayload().containsKey("action")) {
            String jsonAction = (String)msg.getPayload().get("action");
            Action updatedAction = (Action)JsonUtil.fromJson((String)jsonAction, Action.class);
            this.actions.updateResult(updatedAction);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Operation message received from plugin [" + updatedAction.getActionPlugin() + "] with payload [" + updatedAction.getResult() + "]"));
            }
        } else {
            this.msgLog.warnActionResponseMessageWithoutPayload();
        }
    }
}

