/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.standalone;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.naming.InitialContext;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.standalone.MsgLogger;
import org.hawkular.alerts.actions.standalone.ServiceNames;
import org.hawkular.alerts.actions.standalone.StandaloneActionMessage;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.services.ActionListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.jboss.logging.Logger;

public class StandaloneActionPluginListener
implements ActionListener {
    private static final String NUM_THREADS = "hawkular-alerts.standalone-actions-threads";
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(StandaloneActionPluginListener.class);
    private InitialContext ctx;
    private DefinitionsService definitions;
    ExecutorService executorService;
    private Map<String, ActionPluginListener> plugins;

    public StandaloneActionPluginListener(Map<String, ActionPluginListener> plugins) {
        this.plugins = plugins;
        int numThreads = Integer.parseInt(System.getProperty(NUM_THREADS, "10"));
        this.executorService = Executors.newFixedThreadPool(numThreads, new StandaloneThreadFactory());
    }

    public void process(Action action) {
        try {
            this.init();
            if (this.plugins.isEmpty()) {
                this.msgLog.warnNoPluginsFound();
                return;
            }
            if (action == null || action.getActionPlugin() == null) {
                this.msgLog.warnMessageReceivedWithoutPluginInfo();
                return;
            }
            String actionPlugin = action.getActionPlugin();
            ActionPluginListener plugin = this.plugins.get(actionPlugin);
            if (plugin == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Received action [" + actionPlugin + "] but no ActionPluginListener found on this deployment"));
                }
                return;
            }
            StandaloneActionMessage pluginMessage = new StandaloneActionMessage(action);
            if (plugin != null) {
                this.executorService.execute(() -> {
                    try {
                        plugin.process(pluginMessage);
                    }
                    catch (Exception e) {
                        this.log.debug((Object)("Error processing action: " + action.getActionPlugin()), (Throwable)e);
                        this.msgLog.errorProcessingAction(e.getMessage());
                    }
                });
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("Error processing action: " + action.getActionPlugin()), (Throwable)e);
            this.msgLog.errorProcessingAction(e.getMessage());
        }
    }

    private void init() throws Exception {
        if (this.ctx == null) {
            this.ctx = new InitialContext();
        }
        if (this.definitions == null) {
            this.definitions = (DefinitionsService)this.ctx.lookup(ServiceNames.getServiceName(ServiceNames.Service.DEFINITIONS_SERVICE));
        }
    }

    public void close() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    public class StandaloneThreadFactory
    implements ThreadFactory {
        private int counter = 0;
        private static final String PREFIX = "standalone-action-";

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, PREFIX + this.counter++);
        }
    }
}

