/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.irc;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hawkular.alerts.actions.api.ActionMessage;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.api.ActionPluginSender;
import org.hawkular.alerts.actions.api.ActionResponseMessage;
import org.hawkular.alerts.actions.api.MsgLogger;
import org.hawkular.alerts.actions.api.Plugin;
import org.hawkular.alerts.actions.api.Sender;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.model.event.Event;
import org.schwering.irc.lib.IRCConfig;
import org.schwering.irc.lib.IRCConfigBuilder;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCConnectionFactory;

@Plugin(name="irc")
public class IrcPlugin
implements ActionPluginListener {
    static final String IRC_HOST_DEFAULT = "irc.freenode.net";
    static final String IRC_PORT_DEFAULT = "6667";
    static final String IRC_NICK_DEFAULT = "hwk-alerts-bot";
    static final String IRC_PASSWORD_DEFAULT = "H4wk0l43";
    static final String IRC_CHANNEL_DEFAULT = "#hawkular-alerts";
    static final String IRC_DETAIL_DEFAULT = "false";
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    Map<String, String> defaultProperties = new HashMap<String, String>();
    private IRCConnection conn = null;
    private String channel = null;
    private String detail = null;
    @Sender
    ActionPluginSender sender;
    private static final String MESSAGE_PROCESSED = "PROCESSED";
    private static final String MESSAGE_FAILED = "FAILED";

    public IrcPlugin() {
        this.defaultProperties.put("host", IRC_HOST_DEFAULT);
        this.defaultProperties.put("port", IRC_PORT_DEFAULT);
        this.defaultProperties.put("nick", IRC_NICK_DEFAULT);
        this.defaultProperties.put("password", IRC_PASSWORD_DEFAULT);
        this.defaultProperties.put("detail", IRC_DETAIL_DEFAULT);
    }

    public Set<String> getProperties() {
        return this.defaultProperties.keySet();
    }

    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    public void process(ActionMessage msg) throws Exception {
        try {
            if (!this.isConnected()) {
                this.connect(msg.getAction().getProperties());
            }
            this.send(msg.getAction(), Boolean.parseBoolean(this.detail));
            this.msgLog.infoActionReceived("irc", msg.toString());
            Action successAction = msg.getAction();
            successAction.setResult(MESSAGE_PROCESSED);
            this.sendResult(successAction);
        }
        catch (Exception e) {
            Action failedAction = msg.getAction();
            failedAction.setResult(MESSAGE_FAILED);
            this.sendResult(failedAction);
        }
    }

    private boolean isConnected() throws Exception {
        if (this.conn == null) {
            return false;
        }
        return this.conn.isConnected();
    }

    private void connect(Map<String, String> props) throws Exception {
        String host = props == null || !props.containsKey("host") ? IRC_HOST_DEFAULT : props.get("host");
        String port = props == null || !props.containsKey("port") ? IRC_PORT_DEFAULT : props.get("port");
        String nick = props == null || !props.containsKey("nick") ? IRC_NICK_DEFAULT : props.get("nick");
        String password = props == null || !props.containsKey("password") ? IRC_PASSWORD_DEFAULT : props.get("password");
        this.channel = props == null || !props.containsKey("channel") ? IRC_CHANNEL_DEFAULT : props.get("channel");
        this.detail = props == null || !props.containsKey("detail") ? IRC_DETAIL_DEFAULT : props.get("detail");
        IRCConfig config = IRCConfigBuilder.newBuilder().host(host).port(Integer.valueOf(port).intValue()).nick(nick).username(nick).password(password).realname(nick).build();
        this.conn = IRCConnectionFactory.newConnection((IRCConfig)config);
        this.conn.connect();
        this.conn.doJoin(this.channel);
    }

    private void send(Action action, boolean detail) {
        Event e = action.getEvent();
        if (e != null) {
            StringBuilder msg = new StringBuilder();
            msg.append(e.getEventType());
            msg.append(" ");
            msg.append(e.getId());
            msg.append(" at ");
            msg.append(new Date(e.getCtime()).toString());
            this.conn.doPrivmsg(this.channel, msg.toString());
            if (detail) {
                this.conn.doPrivmsg(this.channel, JsonUtil.toJson((Object)e));
            }
        }
    }

    private void sendResult(Action action) {
        if (this.sender == null) {
            throw new IllegalStateException("ActionPluginSender is not present in the plugin");
        }
        if (action == null) {
            throw new IllegalStateException("Action to update result must be not null");
        }
        ActionResponseMessage newMessage = this.sender.createMessage(ActionResponseMessage.Operation.RESULT);
        newMessage.getPayload().put("action", JsonUtil.toJson((Object)action));
        try {
            this.sender.send(newMessage);
        }
        catch (Exception e) {
            this.msgLog.error((Object)"Error sending ActionResponseMessage", (Throwable)e);
        }
    }
}

