/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.sms.registration;

import java.io.IOException;
import java.util.HashSet;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import org.hawkular.alerts.actions.api.log.MsgLogger;
import org.hawkular.alerts.actions.api.model.ActionPluginMessage;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.jboss.logging.Logger;

@Startup
@Singleton
public class RegistrationInit {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(RegistrationInit.class);
    private static final String ACTION_PLUGIN_REGISTER = "HawkularAlertsPluginsQueue";
    @Resource(mappedName="java:/HawkularBusConnectionFactory")
    private QueueConnectionFactory conFactory;
    private ConnectionContextFactory ccf;
    private ProducerConnectionContext pcc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        try {
            this.ccf = new ConnectionContextFactory((ConnectionFactory)this.conFactory);
            this.pcc = this.ccf.createProducerConnectionContext(new Endpoint(Endpoint.Type.QUEUE, ACTION_PLUGIN_REGISTER));
            ActionPluginMessage apMsg = new ActionPluginMessage();
            apMsg.setOp("init");
            apMsg.setActionPlugin("sms");
            HashSet<String> properties = new HashSet<String>();
            properties.add("phone");
            properties.add("description");
            apMsg.setProperties(properties);
            MessageId mid = new MessageProcessor().send(this.pcc, (BasicMessage)apMsg);
            this.msgLog.infoPluginRegistration("sms", mid.toString());
        }
        catch (JMSException e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            this.msgLog.errorCannotSendMessage("sms", e.getMessage());
        }
        finally {
            if (this.pcc != null) {
                try {
                    this.pcc.close();
                    this.pcc = null;
                }
                catch (IOException ignored) {}
            }
            if (this.ccf != null) {
                try {
                    this.ccf.close();
                }
                catch (JMSException jMSException) {}
            }
        }
    }
}

