/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.sms;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.resource.factory.MessageFactory;
import com.twilio.sdk.resource.instance.Account;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.message.BasicNameValuePair;
import org.hawkular.alerts.actions.api.ActionPlugin;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.api.MsgLogger;
import org.hawkular.alerts.actions.api.PluginMessage;
import org.hawkular.alerts.api.model.condition.Alert;

@ActionPlugin(name="sms")
public class SmsPlugin
implements ActionPluginListener {
    static final String ACCOUNT_SID_PROPERTY = "org.hawkular.actions.sms.sid";
    static final String ACCOUNT_SID = System.getProperty("org.hawkular.actions.sms.sid");
    static final String AUTH_TOKEN_PROPERTY = "org.hawkular.actions.sms.token";
    static final String AUTH_TOKEN = System.getProperty("org.hawkular.actions.sms.token");
    static final String FROM_PROPERTY = "org.hawkular.actions.sms.from";
    static final String FROM = System.getProperty("org.hawkular.actions.sms.from");
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    Map<String, String> defaultProperties = new HashMap();
    MessageFactory messageFactory;

    public SmsPlugin() {
        this.defaultProperties.put("phone", "+1555123456");
        this.defaultProperties.put("description", "Default non-valid phone");
        this.setup();
    }

    public Set<String> getProperties() {
        return this.defaultProperties.keySet();
    }

    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    public void process(PluginMessage msg) throws Exception {
        if (this.messageFactory == null) {
            this.msgLog.errorCannotSendMessage("sms", "Plugin is not started");
            return;
        }
        Map properties = msg.getProperties();
        if (properties == null || properties.isEmpty()) {
            this.msgLog.errorCannotSendMessage("sms", "Missing message properties");
            return;
        }
        String to = (String)properties.get("phone");
        if (StringUtils.isBlank((CharSequence)to)) {
            this.msgLog.errorCannotSendMessage("sms", "Missing recipient");
            return;
        }
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(3);
        params.add(new BasicNameValuePair("To", to));
        params.add(new BasicNameValuePair("From", FROM));
        params.add(new BasicNameValuePair("Body", this.prepareMessage(msg)));
        try {
            this.messageFactory.create(params);
        }
        catch (TwilioRestException e) {
            this.msgLog.errorCannotSendMessage("sms", e.getLocalizedMessage());
        }
        this.msgLog.infoActionReceived("sms", msg.toString());
    }

    void setup() {
        if (StringUtils.isBlank((CharSequence)ACCOUNT_SID) || StringUtils.isBlank((CharSequence)AUTH_TOKEN)) {
            String msg = "Configure org.hawkular.actions.sms.sid and org.hawkular.actions.sms.token";
            this.msgLog.errorCannotBeStarted("sms", msg);
            return;
        }
        try {
            TwilioRestClient client = new TwilioRestClient(ACCOUNT_SID, AUTH_TOKEN);
            Account account = client.getAccount();
            this.messageFactory = account.getMessageFactory();
        }
        catch (Exception e) {
            this.msgLog.errorCannotBeStarted("sms", e.getLocalizedMessage());
        }
    }

    private String prepareMessage(PluginMessage msg) {
        String preparedMsg = null;
        if (msg.getAction() != null && msg.getAction().getAlert() != null) {
            Alert alert = msg.getAction().getAlert();
            if (alert != null) {
                preparedMsg = "Alert : " + alert.getTriggerId() + " at " + alert.getCtime() + " -- Severity: " + alert.getSeverity().toString();
            } else {
                preparedMsg = "Message received without data at " + System.currentTimeMillis();
                this.msgLog.warnMessageReceivedWithoutPayload("pagerduty");
            }
        }
        return preparedMsg;
    }
}

