/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.sms;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.resource.factory.MessageFactory;
import com.twilio.sdk.resource.instance.Account;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.message.BasicNameValuePair;
import org.hawkular.alerts.actions.api.ActionMessage;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.api.ActionPluginSender;
import org.hawkular.alerts.actions.api.ActionResponseMessage;
import org.hawkular.alerts.actions.api.MsgLogger;
import org.hawkular.alerts.actions.api.Plugin;
import org.hawkular.alerts.actions.api.Sender;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.model.condition.Alert;

@Plugin(name="sms")
public class SmsPlugin
implements ActionPluginListener {
    static final String ACCOUNT_SID_PROPERTY = "org.hawkular.actions.sms.sid";
    static final String ACCOUNT_SID = System.getProperty("org.hawkular.actions.sms.sid");
    static final String AUTH_TOKEN_PROPERTY = "org.hawkular.actions.sms.token";
    static final String AUTH_TOKEN = System.getProperty("org.hawkular.actions.sms.token");
    static final String FROM_PROPERTY = "org.hawkular.actions.sms.from";
    static final String FROM = System.getProperty("org.hawkular.actions.sms.from");
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    Map<String, String> defaultProperties = new HashMap();
    MessageFactory messageFactory;
    @Sender
    ActionPluginSender sender;
    private static final String MESSAGE_PROCESSED = "PROCESSED";
    private static final String MESSAGE_FAILED = "FAILED";

    public SmsPlugin() {
        this.defaultProperties.put("phone", "+1555123456");
        this.defaultProperties.put("description", "Default non-valid phone");
        this.setup();
    }

    public Set<String> getProperties() {
        return this.defaultProperties.keySet();
    }

    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    public void process(ActionMessage msg) throws Exception {
        if (this.messageFactory == null) {
            this.msgLog.errorCannotProcessMessage("sms", "Plugin is not started");
            return;
        }
        Map properties = msg.getAction().getProperties();
        if (properties == null || properties.isEmpty()) {
            this.msgLog.errorCannotProcessMessage("sms", "Missing message properties");
            return;
        }
        String to = (String)properties.get("phone");
        if (StringUtils.isBlank((CharSequence)to)) {
            this.msgLog.errorCannotProcessMessage("sms", "Missing recipient");
            return;
        }
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(3);
        params.add(new BasicNameValuePair("To", to));
        params.add(new BasicNameValuePair("From", FROM));
        params.add(new BasicNameValuePair("Body", this.prepareMessage(msg)));
        try {
            this.messageFactory.create(params);
        }
        catch (TwilioRestException e) {
            this.msgLog.errorCannotProcessMessage("sms", e.getLocalizedMessage());
            Action failedAction = msg.getAction();
            failedAction.setResult(MESSAGE_FAILED);
            this.sendResult(failedAction);
        }
        this.msgLog.infoActionReceived("sms", msg.toString());
        Action successAction = msg.getAction();
        successAction.setResult(MESSAGE_PROCESSED);
        this.sendResult(successAction);
    }

    void setup() {
        if (StringUtils.isBlank((CharSequence)ACCOUNT_SID) || StringUtils.isBlank((CharSequence)AUTH_TOKEN)) {
            String msg = "Configure org.hawkular.actions.sms.sid and org.hawkular.actions.sms.token";
            this.msgLog.errorCannotBeStarted("sms", msg);
            return;
        }
        try {
            TwilioRestClient client = new TwilioRestClient(ACCOUNT_SID, AUTH_TOKEN);
            Account account = client.getAccount();
            this.messageFactory = account.getMessageFactory();
        }
        catch (Exception e) {
            this.msgLog.errorCannotBeStarted("sms", e.getLocalizedMessage());
        }
    }

    private String prepareMessage(ActionMessage msg) {
        String preparedMsg = null;
        if (msg.getAction() != null && msg.getAction().getAlert() != null) {
            Alert alert = msg.getAction().getAlert();
            if (alert != null) {
                preparedMsg = "Alert : " + alert.getTriggerId() + " at " + alert.getCtime() + " -- Severity: " + alert.getSeverity().toString();
            } else {
                preparedMsg = "Message received without data at " + System.currentTimeMillis();
                this.msgLog.warnMessageReceivedWithoutPayload("pagerduty");
            }
        }
        return preparedMsg;
    }

    private void sendResult(Action action) {
        if (this.sender == null) {
            throw new IllegalStateException("ActionPluginSender is not present in the plugin");
        }
        if (action == null) {
            throw new IllegalStateException("Action to update result must be not null");
        }
        ActionResponseMessage newMessage = this.sender.createMessage(ActionResponseMessage.Operation.RESULT);
        newMessage.getPayload().put("action", JsonUtil.toJson((Object)action));
        try {
            this.sender.send(newMessage);
        }
        catch (Exception e) {
            this.msgLog.error((Object)"Error sending ActionResponseMessage", (Throwable)e);
        }
    }
}

