/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.standalone;

import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.api.PluginMessage;
import org.hawkular.alerts.actions.standalone.MsgLogger;
import org.hawkular.alerts.actions.standalone.StandalonePluginMessage;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.services.ActionListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.jboss.logging.Logger;

public class StandaloneActionPluginListener
implements ActionListener {
    public static final String DEFINITIONS_SERVICE = "java:app/hawkular-alerts-rest/CassDefinitionsServiceImpl";
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(StandaloneActionPluginListener.class);
    private InitialContext ctx;
    private DefinitionsService definitions;
    private Map<String, ActionPluginListener> plugins;

    public StandaloneActionPluginListener(Map<String, ActionPluginListener> plugins) {
        this.plugins = plugins;
    }

    public void process(Action action) {
        try {
            this.init();
            if (this.plugins.isEmpty()) {
                this.msgLog.warnNoPluginsFound();
                return;
            }
            if (action == null || action.getActionPlugin() == null) {
                this.msgLog.warnMessageReceivedWithoutPluginInfo();
                return;
            }
            String actionPlugin = action.getActionPlugin();
            ActionPluginListener plugin = this.plugins.get(actionPlugin);
            if (plugin == null) {
                this.log.debug((Object)("Received action [" + actionPlugin + "] but no ActionPluginListener found on this deployment"));
                return;
            }
            if (this.definitions != null) {
                Map properties = this.definitions.getAction(action.getTenantId(), action.getActionPlugin(), action.getActionId());
                Map defaultProperties = this.definitions.getDefaultActionPlugin(action.getActionPlugin());
                Map<String, String> mixedProps = this.mixProperties(properties, defaultProperties);
                StandalonePluginMessage pluginMessage = new StandalonePluginMessage(action, mixedProps);
                plugin.process((PluginMessage)pluginMessage);
            } else {
                this.msgLog.warnCannotAccessToDefinitionsService();
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("Error processing action: " + action.getActionPlugin()), (Throwable)e);
            this.msgLog.errorProcessingAction(e.getMessage());
        }
    }

    private void init() throws Exception {
        if (this.ctx == null) {
            this.ctx = new InitialContext();
        }
        if (this.definitions == null) {
            this.definitions = (DefinitionsService)this.ctx.lookup(DEFINITIONS_SERVICE);
        }
    }

    private Map<String, String> mixProperties(Map<String, String> props, Map<String, String> defProps) {
        HashMap<String, String> mixed = new HashMap<String, String>();
        if (props != null) {
            mixed.putAll(props);
        }
        if (defProps != null) {
            for (String defKey : defProps.keySet()) {
                mixed.putIfAbsent(defKey, defProps.get(defKey));
            }
        }
        return mixed;
    }
}

