/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.standalone;

import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.standalone.ActionPlugins;
import org.hawkular.alerts.actions.standalone.MsgLogger;
import org.hawkular.alerts.actions.standalone.StandaloneActionPluginListener;
import org.hawkular.alerts.api.services.ActionListener;
import org.hawkular.alerts.api.services.ActionsService;
import org.hawkular.alerts.api.services.DefinitionsService;

@Startup
@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class StandaloneActionPluginRegister {
    public static final String DEFINITIONS_SERVICE = "java:global/hawkular-alerts-rest/CassDefinitionsServiceImpl";
    public static final String ACTIONS_SERVICE = "java:global/hawkular-alerts-rest/MemActionsServiceImpl";
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    DefinitionsService definitions;
    ActionsService actions;

    @PostConstruct
    public void init() {
        try {
            InitialContext ctx = new InitialContext();
            this.definitions = (DefinitionsService)ctx.lookup(DEFINITIONS_SERVICE);
            this.actions = (ActionsService)ctx.lookup(ACTIONS_SERVICE);
        }
        catch (NamingException e) {
            this.msgLog.error("Cannot access to JNDI context", e);
        }
        Map<String, ActionPluginListener> plugins = ActionPlugins.getPlugins();
        for (String actionPlugin : plugins.keySet()) {
            ActionPluginListener actionPluginListener = plugins.get(actionPlugin);
            Set properties = actionPluginListener.getProperties();
            Map defaultProperties = actionPluginListener.getDefaultProperties();
            try {
                if (defaultProperties != null && !defaultProperties.isEmpty()) {
                    this.definitions.addActionPlugin(actionPlugin, defaultProperties);
                } else {
                    this.definitions.addActionPlugin(actionPlugin, properties);
                }
                StandaloneActionPluginListener actionListener = new StandaloneActionPluginListener(ActionPlugins.getPlugins());
                this.actions.addListener((ActionListener)actionListener);
                this.msgLog.infoActionPluginRegistration(actionPlugin);
            }
            catch (Exception e) {
                this.msgLog.errorCannotRegisterPlugin(actionPlugin, e.getMessage());
            }
        }
    }
}

