/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.standalone;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.standalone.ActionPlugins;
import org.hawkular.alerts.actions.standalone.MsgLogger;
import org.hawkular.alerts.actions.standalone.StandaloneActionPluginListener;
import org.hawkular.alerts.api.services.ActionListener;
import org.hawkular.alerts.api.services.ActionsService;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.jboss.logging.Logger;

@Startup
@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class StandaloneActionPluginRegister {
    public static final String DEFINITIONS_SERVICE = "java:global/hawkular-alerts-rest/CassDefinitionsServiceImpl";
    public static final String ACTIONS_SERVICE = "java:global/hawkular-alerts-rest/CassActionsServiceImpl";
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(StandaloneActionPluginRegister.class);
    DefinitionsService definitions;
    ActionsService actions;
    Set<ActionListener> actionListeners = new HashSet<ActionListener>();

    @PostConstruct
    public void init() {
        try {
            InitialContext ctx = new InitialContext();
            this.definitions = (DefinitionsService)ctx.lookup(DEFINITIONS_SERVICE);
            this.actions = (ActionsService)ctx.lookup(ACTIONS_SERVICE);
        }
        catch (NamingException e) {
            this.msgLog.error("Cannot access to JNDI context", e);
        }
        Map<String, ActionPluginListener> plugins = ActionPlugins.getPlugins();
        for (String actionPlugin : plugins.keySet()) {
            ActionPluginListener actionPluginListener = plugins.get(actionPlugin);
            Set properties = actionPluginListener.getProperties();
            Map defaultProperties = actionPluginListener.getDefaultProperties();
            try {
                if (defaultProperties != null && !defaultProperties.isEmpty()) {
                    this.definitions.addActionPlugin(actionPlugin, defaultProperties);
                } else {
                    this.definitions.addActionPlugin(actionPlugin, properties);
                }
                StandaloneActionPluginListener actionListener = new StandaloneActionPluginListener(ActionPlugins.getPlugins());
                this.actions.addListener((ActionListener)actionListener);
                this.actionListeners.add(actionListener);
                this.msgLog.infoActionPluginRegistration(actionPlugin);
            }
            catch (Exception e) {
                this.msgLog.errorCannotRegisterPlugin(actionPlugin, e.getMessage());
            }
        }
    }

    @PreDestroy
    public void close() {
        this.actionListeners.stream().forEach(a -> {
            try {
                if (a instanceof StandaloneActionPluginListener) {
                    ((StandaloneActionPluginListener)a).close();
                }
            }
            catch (Exception e) {
                this.log.debug((Object)e.getMessage(), (Throwable)e);
            }
        });
    }
}

