/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.webhook;

import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.hawkular.alerts.actions.webhook.WebHookApp;
import org.hawkular.alerts.actions.webhook.WebHooks;
import org.jboss.logging.Logger;

@Path(value="/")
public class WebHookHandler {
    private static final Logger log = Logger.getLogger(WebHookHandler.class);
    @HeaderParam(value="Hawkular-Tenant")
    String tenantId;

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response findWebHooks() {
        return WebHookApp.ok((Object)WebHooks.getWebHooks((String)this.tenantId));
    }

    @PUT
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerWebHook(Map<String, String> webhook) {
        if (webhook == null || webhook.isEmpty()) {
            return WebHookApp.badRequest((String)"webhook must be not null");
        }
        if (!webhook.containsKey("url")) {
            return WebHookApp.badRequest((String)"webhook must contain an url");
        }
        String url = webhook.get("url");
        String filter = webhook.containsKey("filter") ? webhook.get("filter") : null;
        try {
            WebHooks.addWebHook((String)this.tenantId, (String)filter, (String)url);
            return WebHookApp.ok();
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return WebHookApp.internalError((String)e.getMessage());
        }
    }

    @DELETE
    @Path(value="/{url}")
    public Response unregisterWebHook(@PathParam(value="url") String url) {
        if (url == null || url.isEmpty()) {
            return WebHookApp.badRequest((String)"webhook url must be not null");
        }
        try {
            WebHooks.removeWebHook((String)this.tenantId, (String)url);
            return WebHookApp.ok();
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return WebHookApp.internalError((String)e.getMessage());
        }
    }
}

