/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.data;

import com.fasterxml.jackson.annotation.JsonInclude;

public abstract class Data
implements Comparable<Data> {
    @JsonInclude
    protected String id;
    @JsonInclude
    protected long timestamp;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Object value;
    @JsonInclude
    protected Type type;

    public Data() {
        this.id = null;
    }

    public Data(String id, long timestamp, Object value, Type type) {
        this.id = id;
        this.timestamp = timestamp <= 0L ? System.currentTimeMillis() : timestamp;
        this.value = value;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp <= 0L ? System.currentTimeMillis() : timestamp;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Data other = (Data)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "Data [id=" + this.id + ", timestamp=" + this.timestamp + ", value=" + this.value + "]";
    }

    @Override
    public int compareTo(Data o) {
        int c = this.id.compareTo(o.id);
        if (0 != c) {
            return c;
        }
        c = Long.compare(this.timestamp, o.timestamp);
        if (0 != c) {
            return c;
        }
        return this.compareValue(this.value, o.value);
    }

    abstract int compareValue(Object var1, Object var2);

    public static enum Type {
        AVAILABILITY,
        NUMERIC,
        STRING;

    }
}

