/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.hawkular.alerts.api.model.condition.AvailabilityCondition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.data.Availability;

public class AvailabilityConditionEval
extends ConditionEval {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private AvailabilityCondition condition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Availability.AvailabilityType value;

    public AvailabilityConditionEval() {
        super(false, 0L);
        this.condition = null;
        this.value = null;
    }

    public AvailabilityConditionEval(AvailabilityCondition condition, Availability avail) {
        super(condition.match(avail.getValue()), avail.getTimestamp());
        this.condition = condition;
        this.value = avail.getValue();
    }

    public AvailabilityCondition getCondition() {
        return this.condition;
    }

    public void setCondition(AvailabilityCondition condition) {
        this.condition = condition;
    }

    public Availability.AvailabilityType getValue() {
        return this.value;
    }

    public void setValue(Availability.AvailabilityType value) {
        this.value = value;
    }

    @Override
    public String getTriggerId() {
        return this.condition.getTriggerId();
    }

    @Override
    public int getConditionSetSize() {
        return this.condition.getConditionSetSize();
    }

    @Override
    public int getConditionSetIndex() {
        return this.condition.getConditionSetIndex();
    }

    @Override
    public String getLog() {
        return this.condition.getLog(this.value) + ", evalTimestamp=" + this.evalTimestamp + ", dataTimestamp=" + this.dataTimestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AvailabilityConditionEval that = (AvailabilityConditionEval)o;
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        return this.value == that.value;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AvailabilityConditionEval [evalTimestamp=" + this.evalTimestamp + ", " + "dataTimestamp=" + this.dataTimestamp + ", " + "condition=" + this.condition + ", " + "value=" + (Object)((Object)this.value) + "]";
    }
}

