/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.trigger;

public class Tag {
    private String tenantId;
    private String triggerId;
    private String category;
    private String name;
    private boolean visible;

    public Tag() {
    }

    public Tag(String name) {
        this(null, null, name, false);
    }

    public Tag(String category, String name) {
        this(null, category, name, false);
    }

    public Tag(String triggerId, String category, String name) {
        this(triggerId, category, name, false);
    }

    public Tag(String triggerId, String category, String name, boolean visible) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Tag can not be null or empty.");
        }
        this.triggerId = triggerId;
        this.category = category;
        this.name = name;
        this.visible = visible;
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        if (this.visible != tag.visible) {
            return false;
        }
        if (this.tenantId != null ? !this.tenantId.equals(tag.tenantId) : tag.tenantId != null) {
            return false;
        }
        if (this.triggerId != null ? !this.triggerId.equals(tag.triggerId) : tag.triggerId != null) {
            return false;
        }
        if (this.category != null ? !this.category.equals(tag.category) : tag.category != null) {
            return false;
        }
        return !(this.name == null ? tag.name != null : !this.name.equals(tag.name));
    }

    public int hashCode() {
        int result = this.tenantId != null ? this.tenantId.hashCode() : 0;
        result = 31 * result + (this.triggerId != null ? this.triggerId.hashCode() : 0);
        result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.visible ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Tag{tenantId='" + this.tenantId + '\'' + ", triggerId='" + this.triggerId + '\'' + ", category='" + this.category + '\'' + ", name='" + this.name + '\'' + ", visible=" + this.visible + '}';
    }
}

