/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Set;
import org.hawkular.alerts.api.model.Severity;
import org.hawkular.alerts.api.model.condition.ConditionEval;

public class Alert {
    @JsonInclude
    private String tenantId;
    @JsonInclude
    private String alertId;
    @JsonInclude
    private String triggerId;
    @JsonInclude
    private long ctime;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Thin
    private List<Set<ConditionEval>> evalSets;
    @JsonInclude
    private Severity severity;
    @JsonInclude
    private Status status;
    @JsonInclude
    private long ackTime;
    @JsonInclude
    private String ackBy;
    @JsonInclude
    private String ackNotes;
    @JsonInclude
    private long resolvedTime;
    @JsonInclude
    private String resolvedBy;
    @JsonInclude
    private String resolvedNotes;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Thin
    private List<Set<ConditionEval>> resolvedEvalSets;

    public Alert() {
    }

    public Alert(String tenantId, String triggerId, Severity severity, List<Set<ConditionEval>> evalSets) {
        this.tenantId = tenantId;
        this.triggerId = triggerId;
        this.severity = null == severity ? Severity.MEDIUM : severity;
        this.evalSets = evalSets;
        this.ctime = System.currentTimeMillis();
        this.status = Status.OPEN;
        this.alertId = triggerId + "|" + this.ctime;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getAlertId() {
        return this.alertId;
    }

    public void setAlertId(String alertId) {
        this.alertId = alertId;
    }

    public List<Set<ConditionEval>> getEvalSets() {
        return this.evalSets;
    }

    public void setEvalSets(List<Set<ConditionEval>> evalSets) {
        this.evalSets = evalSets;
    }

    public long getCtime() {
        return this.ctime;
    }

    public void setCtime(long ctime) {
        this.ctime = ctime;
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getAckTime() {
        return this.ackTime;
    }

    public void setAckTime(long ackTime) {
        this.ackTime = ackTime;
    }

    public String getAckBy() {
        return this.ackBy;
    }

    public void setAckBy(String ackBy) {
        this.ackBy = ackBy;
    }

    public String getAckNotes() {
        return this.ackNotes;
    }

    public void setAckNotes(String ackNotes) {
        this.ackNotes = ackNotes;
    }

    public long getResolvedTime() {
        return this.resolvedTime;
    }

    public void setResolvedTime(long resolvedTime) {
        this.resolvedTime = resolvedTime;
    }

    public String getResolvedBy() {
        return this.resolvedBy;
    }

    public void setResolvedBy(String resolvedBy) {
        this.resolvedBy = resolvedBy;
    }

    public String getResolvedNotes() {
        return this.resolvedNotes;
    }

    public void setResolvedNotes(String resolvedNotes) {
        this.resolvedNotes = resolvedNotes;
    }

    public List<Set<ConditionEval>> getResolvedEvalSets() {
        return this.resolvedEvalSets;
    }

    public void setResolvedEvalSets(List<Set<ConditionEval>> resolvedEvalSets) {
        this.resolvedEvalSets = resolvedEvalSets;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alertId == null ? 0 : this.alertId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Alert other = (Alert)obj;
        return !(this.alertId == null ? other.alertId != null : !this.alertId.equals(other.alertId));
    }

    public String toString() {
        return "Alert [alertId=" + this.alertId + ", status=" + (Object)((Object)this.status) + ", ackTime=" + this.ackTime + ", ackBy=" + this.ackBy + ", resolvedTime=" + this.resolvedTime + ", resolvedBy=" + this.resolvedBy + "]";
    }

    public static enum Status {
        OPEN,
        ACKNOWLEDGED,
        RESOLVED;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Thin {
    }
}

