/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.trigger;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hawkular.alerts.api.model.Severity;

public abstract class TriggerTemplate {
    @JsonInclude
    private String name;
    @JsonInclude
    private String description;
    @JsonInclude
    private boolean autoDisable;
    @JsonInclude
    private boolean autoResolve;
    @JsonInclude
    private boolean autoResolveAlerts;
    @JsonInclude
    private Severity severity;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Set<String>> actions;
    @JsonInclude
    private Match firingMatch;
    @JsonInclude
    private Match autoResolveMatch;

    public TriggerTemplate(String name) {
        this.name = name;
        this.autoDisable = false;
        this.autoResolve = false;
        this.autoResolveAlerts = true;
        this.severity = Severity.MEDIUM;
        this.firingMatch = Match.ALL;
        this.autoResolveMatch = Match.ALL;
        this.actions = new HashMap<String, Set<String>>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Trigger name must be non-empty.");
        }
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isAutoDisable() {
        return this.autoDisable;
    }

    public void setAutoDisable(boolean autoDisable) {
        this.autoDisable = autoDisable;
    }

    public boolean isAutoResolve() {
        return this.autoResolve;
    }

    public void setAutoResolve(boolean autoResolve) {
        this.autoResolve = autoResolve;
    }

    public boolean isAutoResolveAlerts() {
        return this.autoResolveAlerts;
    }

    public void setAutoResolveAlerts(boolean autoResolveAlerts) {
        this.autoResolveAlerts = autoResolveAlerts;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public Match getFiringMatch() {
        return this.firingMatch;
    }

    public void setFiringMatch(Match firingMatch) {
        this.firingMatch = firingMatch;
    }

    public Match getAutoResolveMatch() {
        return this.autoResolveMatch;
    }

    public void setAutoResolveMatch(Match autoResolveMatch) {
        this.autoResolveMatch = autoResolveMatch;
    }

    public Map<String, Set<String>> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, Set<String>> actions) {
        this.actions = actions;
    }

    public void addAction(String actionPlugin, String actionId) {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("ActionPlugin must be non-empty.");
        }
        if (actionId == null || actionId.isEmpty()) {
            throw new IllegalArgumentException("ActionId must be non-empty.");
        }
        if (this.actions.get(actionPlugin) == null) {
            this.actions.put(actionPlugin, new HashSet());
        }
        this.actions.get(actionPlugin).add(actionId);
    }

    public void addActions(String actionPlugin, Set<String> actionIds) {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("ActionPlugin must be non-empty.");
        }
        if (actionIds == null) {
            throw new IllegalArgumentException("ActionIds must be non null");
        }
        if (this.actions.get(actionPlugin) == null) {
            this.actions.put(actionPlugin, new HashSet());
        }
        this.actions.get(actionPlugin).addAll(actionIds);
    }

    public void removeAction(String actionPlugin, String actionId) {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("actionPlugin must be non-empty.");
        }
        if (actionId == null || actionId.isEmpty()) {
            throw new IllegalArgumentException("ActionId must be non-empty.");
        }
        if (this.actions.get(actionPlugin) != null) {
            this.actions.get(actionPlugin).remove(actionId);
        }
    }

    public String toString() {
        return "TriggerTemplate [name=" + this.name + ", " + "description=" + this.description + ", " + "firingMatch=" + (Object)((Object)this.firingMatch) + ", " + "safetyMatch=" + (Object)((Object)this.autoResolveMatch) + "]";
    }

    public static enum Match {
        ALL,
        ANY;

    }
}

