/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.hawkular.alerts.api.model.trigger.Trigger;

public abstract class Condition {
    @JsonInclude
    protected String tenantId;
    @JsonInclude
    protected String triggerId;
    @JsonInclude
    protected Trigger.Mode triggerMode;
    @JsonInclude
    protected Type type;
    @JsonIgnore
    protected int conditionSetSize;
    @JsonIgnore
    protected int conditionSetIndex;
    @JsonInclude
    protected String conditionId;

    public Condition() {
    }

    public Condition(String triggerId, Trigger.Mode triggerMode, int conditionSetSize, int conditionSetIndex, Type type) {
        this.triggerId = triggerId;
        this.triggerMode = triggerMode;
        this.conditionSetSize = conditionSetSize;
        this.conditionSetIndex = conditionSetIndex;
        this.type = type;
        this.updateId();
    }

    public int getConditionSetIndex() {
        return this.conditionSetIndex;
    }

    public void setConditionSetIndex(int conditionSetIndex) {
        this.conditionSetIndex = conditionSetIndex;
        this.updateId();
    }

    public int getConditionSetSize() {
        return this.conditionSetSize;
    }

    public void setConditionSetSize(int conditionSetSize) {
        this.conditionSetSize = conditionSetSize;
        this.updateId();
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
        this.updateId();
    }

    public Trigger.Mode getTriggerMode() {
        return this.triggerMode;
    }

    public void setTriggerMode(Trigger.Mode triggerMode) {
        this.triggerMode = triggerMode;
        this.updateId();
    }

    public String getConditionId() {
        return this.conditionId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    private void updateId() {
        StringBuilder sb = new StringBuilder(this.triggerId);
        sb.append("-").append(this.triggerMode.name());
        sb.append("-").append(this.conditionSetSize);
        sb.append("-").append(this.conditionSetIndex);
        this.conditionId = sb.toString();
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conditionId == null ? 0 : this.conditionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Condition other = (Condition)obj;
        return !(this.conditionId == null ? other.conditionId != null : !this.conditionId.equals(other.conditionId));
    }

    public String toString() {
        return "Condition [triggerId=" + this.triggerId + ", triggerMode=" + (Object)((Object)this.triggerMode) + ", conditionSetSize=" + this.conditionSetSize + ", conditionSetIndex=" + this.conditionSetIndex + "]";
    }

    public abstract String getDataId();

    public static enum Type {
        AVAILABILITY,
        COMPARE,
        STRING,
        THRESHOLD,
        RANGE,
        EXTERNAL;

    }
}

