/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.condition.ThresholdRangeCondition;
import org.hawkular.alerts.api.model.data.NumericData;

public class ThresholdRangeConditionEval
extends ConditionEval {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ThresholdRangeCondition condition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double value;

    public ThresholdRangeConditionEval() {
        super(Condition.Type.RANGE, false, 0L, null);
        this.condition = null;
        this.value = null;
    }

    public ThresholdRangeConditionEval(ThresholdRangeCondition condition, NumericData data) {
        super(Condition.Type.RANGE, condition.match(data.getValue()), data.getTimestamp(), data.getContext());
        this.condition = condition;
        this.value = data.getValue();
    }

    public ThresholdRangeCondition getCondition() {
        return this.condition;
    }

    public void setCondition(ThresholdRangeCondition condition) {
        this.condition = condition;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    @Override
    public String getTriggerId() {
        return this.condition.getTriggerId();
    }

    @Override
    public int getConditionSetSize() {
        return this.condition.getConditionSetSize();
    }

    @Override
    public int getConditionSetIndex() {
        return this.condition.getConditionSetIndex();
    }

    @Override
    public String getLog() {
        return this.condition.getLog(this.value) + ", evalTimestamp=" + this.evalTimestamp + ", dataTimestamp=" + this.dataTimestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThresholdRangeConditionEval that = (ThresholdRangeConditionEval)o;
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ThresholdRangeConditionEval [evalTimestamp=" + this.evalTimestamp + ", " + "dataTimestamp=" + this.dataTimestamp + ", " + "condition=" + this.condition + ", " + "value=" + this.value + "]";
    }
}

