/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import org.hawkular.alerts.api.model.data.Availability;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.data.NumericData;
import org.hawkular.alerts.api.model.data.StringData;

public class MixedData {
    private Collection<Availability> availability = new ArrayList<Availability>();
    private Collection<NumericData> numericData = new ArrayList<NumericData>();
    private Collection<StringData> stringData = new ArrayList<StringData>();

    public Collection<Availability> getAvailability() {
        return this.availability;
    }

    public void setAvailability(Collection<Availability> availability) {
        if (null == availability) {
            this.availability.clear();
        } else {
            this.availability = availability;
        }
    }

    public Collection<NumericData> getNumericData() {
        return this.numericData;
    }

    public void setNumericData(Collection<NumericData> numericData) {
        if (null == numericData) {
            this.numericData.clear();
        } else {
            this.numericData = numericData;
        }
    }

    public Collection<StringData> getStringData() {
        return this.stringData;
    }

    public void setStringData(Collection<StringData> stringData) {
        if (null == stringData) {
            this.stringData.clear();
        } else {
            this.stringData = stringData;
        }
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.availability.isEmpty() && this.numericData.isEmpty() && this.stringData.isEmpty();
    }

    @JsonIgnore
    public int size() {
        return this.availability.size() + this.numericData.size() + this.stringData.size();
    }

    @JsonIgnore
    public void clear() {
        this.availability.clear();
        this.numericData.clear();
        this.stringData.clear();
    }

    @JsonIgnore
    public Collection<Data> asCollection() {
        ArrayList<Data> result = new ArrayList<Data>(this.size());
        result.addAll(this.availability);
        result.addAll(this.numericData);
        result.addAll(this.stringData);
        return result;
    }

    public String toString() {
        return "MixedData [availability=" + this.availability + ", numericData=" + this.numericData + ", stringData=" + this.stringData + "]";
    }
}

