/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.data;

import java.util.Map;
import org.hawkular.alerts.api.model.data.Data;

public class NumericData
extends Data {
    public NumericData() {
        this(null, 0L, Double.NaN, null);
    }

    public NumericData(String id, long timestamp, Double value) {
        this(id, timestamp, value, null);
    }

    public NumericData(String id, long timestamp, Double value, Map<String, String> context) {
        super(id, timestamp, null == value ? Double.NaN : value, Data.Type.NUMERIC, context);
    }

    @Override
    public Double getValue() {
        return (Double)this.value;
    }

    public void setValue(Double value) {
        super.setValue(null == value ? Double.NaN : value);
    }

    @Override
    public String toString() {
        return "NumericData [id=" + this.id + ", timestamp=" + this.timestamp + ", value=" + this.value + "]";
    }

    @Override
    int compareValue(Object value1, Object value2) {
        Double v1 = (Double)value1;
        Double v2 = (Double)value2;
        return v1.compareTo(v2);
    }
}

