/*
 * Copyright 2015 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.hawkular.alerts.api.json;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;

/**
 * Json serialization/deserialization utility for Alerts using Jackson implementation.
 *
 * @author Lucas Ponce
 */
public class JsonUtil {

    private static JsonUtil instance = new JsonUtil();
    private ObjectMapper mapper;
    private ObjectMapper mapperThin;

    private JsonUtil() {
        mapper = new ObjectMapper();

        SimpleModule simpleModule = new SimpleModule();
        simpleModule.setDeserializerModifier(new JacksonDeserializer.AlertThinDeserializer());
        mapperThin = new ObjectMapper();
        mapperThin.registerModule(simpleModule);
    }

    public static String toJson(Object resource) {
        try {
            return instance.mapper.writeValueAsString(resource);
        } catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return fromJson(json,clazz, false);
    }

    public static <T> T fromJson(String json, Class<T> clazz, boolean thin) {
        try {
            return thin ? instance.mapperThin.readValue(json, clazz) : instance.mapper.readValue(json, clazz);
        } catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}
