/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Map;
import org.hawkular.alerts.api.json.JacksonDeserializer;
import org.hawkular.alerts.api.model.condition.Condition;

@JsonDeserialize(using=JacksonDeserializer.ConditionEvalDeserializer.class)
public abstract class ConditionEval {
    @JsonIgnore
    protected boolean match;
    @JsonInclude
    protected long evalTimestamp;
    @JsonInclude
    protected long dataTimestamp;
    @JsonIgnore
    protected boolean used;
    @JsonInclude
    protected Condition.Type type;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected Map<String, String> context;

    public ConditionEval() {
    }

    public ConditionEval(Condition.Type type, boolean match, long dataTimestamp, Map<String, String> context) {
        this.type = type;
        this.match = match;
        this.dataTimestamp = dataTimestamp;
        this.evalTimestamp = System.currentTimeMillis();
        this.used = false;
        this.context = context;
    }

    public boolean isMatch() {
        return this.match;
    }

    public void setMatch(boolean match) {
        this.match = match;
    }

    public long getEvalTimestamp() {
        return this.evalTimestamp;
    }

    public void setEvalTimestamp(long evalTimestamp) {
        this.evalTimestamp = evalTimestamp;
    }

    public long getDataTimestamp() {
        return this.dataTimestamp;
    }

    public void setDataTimestamp(long dataTimestamp) {
        this.dataTimestamp = dataTimestamp;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public Condition.Type getType() {
        return this.type;
    }

    public void setType(Condition.Type type) {
        this.type = type;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    @JsonIgnore
    public abstract String getTriggerId();

    @JsonIgnore
    public abstract int getConditionSetSize();

    @JsonIgnore
    public abstract int getConditionSetIndex();

    @JsonIgnore
    public abstract String getLog();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionEval that = (ConditionEval)o;
        if (this.evalTimestamp != that.evalTimestamp) {
            return false;
        }
        if (this.dataTimestamp != that.dataTimestamp) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return !(this.context == null ? that.context != null : !this.context.equals(that.context));
    }

    public int hashCode() {
        int result = (int)(this.evalTimestamp ^ this.evalTimestamp >>> 32);
        result = 31 * result + (int)(this.dataTimestamp ^ this.dataTimestamp >>> 32);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        return result;
    }
}

