/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;

public abstract class Data
implements Comparable<Data> {
    @JsonInclude
    protected String id;
    @JsonInclude
    protected long timestamp;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Object value;
    @JsonInclude
    protected Type type;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected Map<String, String> context;

    public Data() {
        this.id = null;
    }

    public Data(String id, long timestamp, Object value, Type type) {
        this(id, timestamp, value, type, null);
    }

    public Data(String id, long timestamp, Object value, Type type, Map<String, String> context) {
        this.id = id;
        this.timestamp = timestamp <= 0L ? System.currentTimeMillis() : timestamp;
        this.value = value;
        this.type = type;
        this.context = context;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp <= 0L ? System.currentTimeMillis() : timestamp;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public void addProperty(String name, String value) {
        if (null == name || null == value) {
            throw new IllegalArgumentException("Propety must have non-null name and value");
        }
        if (null == this.context) {
            this.context = new HashMap<String, String>();
        }
        this.context.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Data data = (Data)o;
        if (this.timestamp != data.timestamp) {
            return false;
        }
        if (this.id != null ? !this.id.equals(data.id) : data.id != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(data.value) : data.value != null) {
            return false;
        }
        if (this.type != data.type) {
            return false;
        }
        return !(this.context == null ? data.context != null : !this.context.equals(data.context));
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Data [id=" + this.id + ", timestamp=" + this.timestamp + ", value=" + this.value + ", context=" + this.context + "]";
    }

    @Override
    public int compareTo(Data o) {
        int c = this.id.compareTo(o.id);
        if (0 != c) {
            return c;
        }
        c = Long.compare(this.timestamp, o.timestamp);
        if (0 != c) {
            return c;
        }
        return this.compareValue(this.value, o.value);
    }

    abstract int compareValue(Object var1, Object var2);

    public static enum Type {
        AVAILABILITY,
        NUMERIC,
        STRING;

    }
}

