/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.paging;

import java.util.Comparator;
import org.hawkular.alerts.api.model.condition.Alert;
import org.hawkular.alerts.api.model.paging.Order;

public class AlertComparator
implements Comparator<Alert> {
    private Field field;
    private Order.Direction direction;

    public AlertComparator() {
        this(Field.ALERT_ID, Order.Direction.ASCENDING);
    }

    public AlertComparator(Field field, Order.Direction direction) {
        this.field = field;
        this.direction = direction;
    }

    @Override
    public int compare(Alert o1, Alert o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return 1;
        }
        if (o1 != null && o2 == null) {
            return -1;
        }
        int iOrder = this.direction == Order.Direction.ASCENDING ? 1 : -1;
        switch (this.field) {
            case ALERT_ID: {
                return o1.getAlertId().compareTo(o2.getAlertId()) * iOrder;
            }
            case TRIGGER_ID: {
                if (o1.getTriggerId() == null && o2.getTriggerId() == null) {
                    return 0;
                }
                if (o1.getTriggerId() == null && o2.getTriggerId() != null) {
                    return 1;
                }
                if (o1.getTriggerId() != null && o2.getTriggerId() == null) {
                    return -1;
                }
                return o1.getTriggerId().compareTo(o2.getTriggerId()) * iOrder;
            }
            case CTIME: {
                return (int)((o1.getCtime() - o2.getCtime()) * (long)iOrder);
            }
            case SEVERITY: {
                if (o1.getSeverity() == null && o2.getSeverity() == null) {
                    return 0;
                }
                if (o1.getSeverity() == null && o2.getSeverity() != null) {
                    return 1;
                }
                if (o1.getSeverity() != null && o2.getSeverity() == null) {
                    return -1;
                }
                return o1.getSeverity().compareTo(o2.getSeverity()) * iOrder;
            }
            case STATUS: {
                if (o1.getStatus() == null && o2.getStatus() == null) {
                    return 0;
                }
                if (o1.getStatus() == null && o2.getStatus() != null) {
                    return 1;
                }
                if (o1.getStatus() != null && o2.getStatus() == null) {
                    return -1;
                }
                return o1.getStatus().compareTo(o2.getStatus()) * iOrder;
            }
        }
        return 0;
    }

    public static enum Field {
        ALERT_ID("alertId"),
        TRIGGER_ID("triggerId"),
        CTIME("ctime"),
        SEVERITY("severity"),
        STATUS("status");

        private String text;

        private Field(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static Field getField(String text) {
            if (text == null || text.isEmpty()) {
                return ALERT_ID;
            }
            for (Field f : Field.values()) {
                if (f.getText().compareToIgnoreCase(text) != 0) continue;
                return f;
            }
            return ALERT_ID;
        }
    }
}

