/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.trigger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.UUID;
import org.hawkular.alerts.api.model.trigger.TriggerTemplate;

public class Trigger
extends TriggerTemplate {
    @JsonInclude
    private String id;
    @JsonInclude
    private boolean enabled;
    @JsonIgnore
    private Mode mode;
    @JsonIgnore
    private transient TriggerTemplate.Match match;
    @JsonInclude
    private String tenantId;

    public Trigger() {
        this("defaultName");
    }

    public Trigger(String name) {
        this(Trigger.generateId(), name);
    }

    public static String generateId() {
        return UUID.randomUUID().toString();
    }

    public Trigger(String id, String name) {
        super(name);
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Trigger id must be non-empty");
        }
        this.id = id;
        this.enabled = false;
        this.mode = Mode.FIRING;
        this.match = TriggerTemplate.Match.ALL;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonIgnore
    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.setMatch(this.mode == Mode.FIRING ? this.getFiringMatch() : this.getAutoResolveMatch());
    }

    @JsonIgnore
    public TriggerTemplate.Match getMatch() {
        return this.match;
    }

    public void setMatch(TriggerTemplate.Match match) {
        this.match = match;
    }

    @Override
    public void setFiringMatch(TriggerTemplate.Match firingMatch) {
        super.setFiringMatch(firingMatch);
        this.setMatch(this.mode == Mode.FIRING ? this.getFiringMatch() : this.getAutoResolveMatch());
    }

    @Override
    public void setAutoResolveMatch(TriggerTemplate.Match autoResolveMatch) {
        super.setAutoResolveMatch(autoResolveMatch);
        this.setMatch(this.mode == Mode.FIRING ? this.getFiringMatch() : this.getAutoResolveMatch());
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trigger trigger = (Trigger)o;
        if (this.id != null ? !this.id.equals(trigger.id) : trigger.id != null) {
            return false;
        }
        return !(this.tenantId == null ? trigger.tenantId != null : !this.tenantId.equals(trigger.tenantId));
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.tenantId != null ? this.tenantId.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Trigger [tenantId=" + this.tenantId + " id=" + this.id + ", enabled=" + this.enabled + ", mode=" + (Object)((Object)this.mode) + ", getName()=" + this.getName() + ", isAutoDisable()=" + this.isAutoDisable() + ", isAutoEnable()=" + this.isAutoEnable() + ", isAutoResolve()=" + this.isAutoResolve() + "]";
    }

    public static enum Mode {
        FIRING,
        AUTORESOLVE;

    }
}

