/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.condition.EventCondition;
import org.hawkular.alerts.api.model.event.Event;

public class EventConditionEval
extends ConditionEval {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private EventCondition condition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Event value;

    public EventConditionEval() {
        super(Condition.Type.EVENT, false, 0L, null);
        this.condition = null;
        this.value = null;
    }

    public EventConditionEval(EventCondition condition, Event value) {
        super(Condition.Type.EVENT, condition.match(value), value.getCtime(), value.getContext());
        this.condition = condition;
        this.value = value;
    }

    public EventCondition getCondition() {
        return this.condition;
    }

    public void setCondition(EventCondition condition) {
        this.condition = condition;
    }

    public Event getValue() {
        return this.value;
    }

    public void setValue(Event value) {
        this.value = value;
    }

    @Override
    public String getTriggerId() {
        return this.condition.getTriggerId();
    }

    @Override
    public int getConditionSetSize() {
        return this.condition.getConditionSetSize();
    }

    @Override
    public int getConditionSetIndex() {
        return this.condition.getConditionSetIndex();
    }

    @Override
    public String getLog() {
        return this.condition.getLog(this.value) + ", evalTimestamp=" + this.evalTimestamp + ", dataTimestamp=" + this.dataTimestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventConditionEval that = (EventConditionEval)o;
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EventConditionEval{condition=" + this.condition + ", value=" + this.value + '}';
    }
}

