/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.trigger.Mode;

public class ExternalCondition
extends Condition {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String systemId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String dataId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String expression;

    public ExternalCondition() {
        this("DefaultId", Mode.FIRING, 1, 1, null, null, null);
    }

    public ExternalCondition(String triggerId, Mode triggerMode, String dataId, String systemId, String expression) {
        this(triggerId, triggerMode, 1, 1, dataId, systemId, expression);
    }

    public ExternalCondition(String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, String dataId, String systemId, String expression) {
        super(triggerId, triggerMode, conditionSetSize, conditionSetIndex, Condition.Type.EXTERNAL);
        this.systemId = systemId;
        this.dataId = dataId;
        this.expression = expression;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Override
    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getLog(String value) {
        return this.triggerId + " : " + value + " " + this.expression;
    }

    public boolean match(String value) {
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dataId == null ? 0 : this.dataId.hashCode());
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.systemId == null ? 0 : this.systemId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalCondition other = (ExternalCondition)obj;
        if (this.dataId == null ? other.dataId != null : !this.dataId.equals(other.dataId)) {
            return false;
        }
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        return !(this.systemId == null ? other.systemId != null : !this.systemId.equals(other.systemId));
    }

    @Override
    public String toString() {
        return "ExternalCondition [systemId=" + this.systemId + ", dataId=" + this.dataId + ", expression=" + this.expression + "]";
    }
}

