/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.condition.StringCondition;
import org.hawkular.alerts.api.model.data.Data;

public class StringConditionEval
extends ConditionEval {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private StringCondition condition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String value;

    public StringConditionEval() {
        super(Condition.Type.STRING, false, 0L, null);
        this.condition = null;
        this.value = null;
    }

    public StringConditionEval(StringCondition condition, Data data) {
        super(Condition.Type.STRING, condition.match(data.getValue()), data.getTimestamp(), data.getContext());
        this.condition = condition;
        this.value = data.getValue();
    }

    public StringCondition getCondition() {
        return this.condition;
    }

    public void setCondition(StringCondition condition) {
        this.condition = condition;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getTriggerId() {
        return this.condition.getTriggerId();
    }

    @Override
    public int getConditionSetSize() {
        return this.condition.getConditionSetSize();
    }

    @Override
    public int getConditionSetIndex() {
        return this.condition.getConditionSetIndex();
    }

    @Override
    public String getLog() {
        return this.condition.getLog(this.value) + ", evalTimestamp=" + this.evalTimestamp + ", dataTimestamp=" + this.dataTimestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StringConditionEval that = (StringConditionEval)o;
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StringConditionEval [condition=" + this.condition + ", value=" + this.value + ", match=" + this.match + ", evalTimestamp=" + this.evalTimestamp + ", dataTimestamp=" + this.dataTimestamp + "]";
    }
}

