/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.trigger.Mode;

public class ThresholdRangeCondition
extends Condition {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String dataId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Operator operatorLow;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Operator operatorHigh;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double thresholdLow;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double thresholdHigh;
    @JsonInclude
    private boolean inRange;

    public ThresholdRangeCondition() {
        this("DefaultId", 1, 1, null, null, null, null, null, false);
    }

    public ThresholdRangeCondition(String triggerId, String dataId, Operator operatorLow, Operator operatorHigh, Double thresholdLow, Double thresholdHigh, boolean inRange) {
        this(triggerId, Mode.FIRING, 1, 1, dataId, operatorLow, operatorHigh, thresholdLow, thresholdHigh, inRange);
    }

    public ThresholdRangeCondition(String triggerId, Mode triggerMode, String dataId, Operator operatorLow, Operator operatorHigh, Double thresholdLow, Double thresholdHigh, boolean inRange) {
        this(triggerId, triggerMode, 1, 1, dataId, operatorLow, operatorHigh, thresholdLow, thresholdHigh, inRange);
    }

    public ThresholdRangeCondition(String triggerId, int conditionSetSize, int conditionSetIndex, String dataId, Operator operatorLow, Operator operatorHigh, Double thresholdLow, Double thresholdHigh, boolean inRange) {
        this(triggerId, Mode.FIRING, conditionSetSize, conditionSetIndex, dataId, operatorLow, operatorHigh, thresholdLow, thresholdHigh, inRange);
    }

    public ThresholdRangeCondition(String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, String dataId, Operator operatorLow, Operator operatorHigh, Double thresholdLow, Double thresholdHigh, boolean inRange) {
        super(triggerId, triggerMode, conditionSetSize, conditionSetIndex, Condition.Type.RANGE);
        this.dataId = dataId;
        this.operatorLow = operatorLow;
        this.operatorHigh = operatorHigh;
        this.thresholdLow = thresholdLow;
        this.thresholdHigh = thresholdHigh;
        this.inRange = inRange;
    }

    @Override
    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public boolean isInRange() {
        return this.inRange;
    }

    public void setInRange(boolean inRange) {
        this.inRange = inRange;
    }

    public Operator getOperatorHigh() {
        return this.operatorHigh;
    }

    public void setOperatorHigh(Operator operatorHigh) {
        this.operatorHigh = operatorHigh;
    }

    public Operator getOperatorLow() {
        return this.operatorLow;
    }

    public void setOperatorLow(Operator operatorLow) {
        this.operatorLow = operatorLow;
    }

    public Double getThresholdHigh() {
        return this.thresholdHigh;
    }

    public void setThresholdHigh(Double thresholdHigh) {
        this.thresholdHigh = thresholdHigh;
    }

    public Double getThresholdLow() {
        return this.thresholdLow;
    }

    public void setThresholdLow(Double thresholdLow) {
        this.thresholdLow = thresholdLow;
    }

    public String getLog(double value) {
        String range = this.operatorLow.getLow() + this.thresholdLow + " , " + this.thresholdHigh + this.operatorHigh.getHigh();
        return this.triggerId + " : " + value + " " + range;
    }

    public boolean match(double value) {
        boolean aboveLow = false;
        boolean belowHigh = false;
        switch (this.operatorLow) {
            case INCLUSIVE: {
                aboveLow = value >= this.thresholdLow;
                break;
            }
            case EXCLUSIVE: {
                aboveLow = value > this.thresholdLow;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown operatorLow: " + this.operatorLow.name());
            }
        }
        if (!aboveLow) {
            return !this.inRange;
        }
        switch (this.operatorHigh) {
            case INCLUSIVE: {
                belowHigh = value <= this.thresholdHigh;
                break;
            }
            case EXCLUSIVE: {
                belowHigh = value < this.thresholdHigh;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown operatorHigh: " + this.operatorLow.name());
            }
        }
        return belowHigh == this.inRange;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThresholdRangeCondition that = (ThresholdRangeCondition)o;
        if (this.inRange != that.inRange) {
            return false;
        }
        if (this.dataId != null ? !this.dataId.equals(that.dataId) : that.dataId != null) {
            return false;
        }
        if (this.operatorHigh != that.operatorHigh) {
            return false;
        }
        if (this.operatorLow != that.operatorLow) {
            return false;
        }
        if (this.thresholdHigh != null ? !this.thresholdHigh.equals(that.thresholdHigh) : that.thresholdHigh != null) {
            return false;
        }
        return !(this.thresholdLow != null ? !this.thresholdLow.equals(that.thresholdLow) : that.thresholdLow != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dataId != null ? this.dataId.hashCode() : 0);
        result = 31 * result + (this.operatorLow != null ? this.operatorLow.hashCode() : 0);
        result = 31 * result + (this.operatorHigh != null ? this.operatorHigh.hashCode() : 0);
        result = 31 * result + (this.thresholdLow != null ? this.thresholdLow.hashCode() : 0);
        result = 31 * result + (this.thresholdHigh != null ? this.thresholdHigh.hashCode() : 0);
        result = 31 * result + (this.inRange ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ThresholdRangeCondition [triggerId='" + this.triggerId + "', " + "triggerMode=" + (Object)((Object)this.triggerMode) + ", " + "dataId=" + (this.dataId == null ? null : '\'' + this.dataId + '\'') + ", " + "operatorLow=" + (this.operatorLow == null ? null : '\'' + this.operatorLow.toString() + '\'') + ", " + "operatorHigh=" + (this.operatorHigh == null ? null : '\'' + this.operatorHigh.toString() + '\'') + ", " + "thresholdLow=" + this.thresholdLow + ", " + "thresholdHigh=" + this.thresholdHigh + ", " + "inRange=" + this.inRange + "]";
    }

    public static enum Operator {
        INCLUSIVE("[", "]"),
        EXCLUSIVE("(", ")");

        private String low;
        private String high;

        private Operator(String low, String high) {
            this.low = low;
            this.high = high;
        }

        public String getLow() {
            return this.low;
        }

        public String getHigh() {
            return this.high;
        }
    }
}

