/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.dampening;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.trigger.Match;
import org.hawkular.alerts.api.model.trigger.Mode;

public class Dampening {
    @JsonInclude
    private String tenantId;
    @JsonInclude
    private String triggerId;
    @JsonInclude
    private Mode triggerMode;
    @JsonInclude
    private Type type;
    @JsonInclude
    @ApiModelProperty(value="Number of required true evaluations for STRICT, RELAXED_COUNT, RELAXED_TIME", allowableValues=">= 1")
    private int evalTrueSetting;
    @JsonInclude
    @ApiModelProperty(value="Number of allowed evaluation attempts for RELAXED_COUNT", allowableValues="> evalTrueSetting")
    private int evalTotalSetting;
    @JsonInclude
    @ApiModelProperty(value="Time period in milliseconds for RELAXED_TIME, STRICT_TIME, STRICT_TIMEOUT", allowableValues="> 0")
    private long evalTimeSetting;
    @JsonInclude
    protected String dampeningId;
    @JsonIgnore
    private transient int numTrueEvals;
    @JsonIgnore
    private transient int numEvals;
    @JsonIgnore
    private transient long trueEvalsStartTime;
    @JsonIgnore
    private transient Map<Integer, ConditionEval> currentEvals = new HashMap<Integer, ConditionEval>(5);
    @JsonIgnore
    private transient boolean satisfied;
    @JsonIgnore
    private transient List<Set<ConditionEval>> satisfyingEvals = new ArrayList<Set<ConditionEval>>();

    public Dampening() {
        this("Default", Mode.FIRING, Type.STRICT, 1, 1, 0L);
    }

    public static Dampening forStrict(String triggerId, Mode triggerMode, int numConsecutiveTrueEvals) {
        if (numConsecutiveTrueEvals < 1) {
            throw new IllegalArgumentException("NumConsecutiveTrueEvals must be >= 1");
        }
        return new Dampening(triggerId, triggerMode, Type.STRICT, numConsecutiveTrueEvals, numConsecutiveTrueEvals, 0L);
    }

    public static Dampening forRelaxedCount(String triggerId, Mode triggerMode, int numTrueEvals, int numTotalEvals) {
        if (numTrueEvals < 1) {
            throw new IllegalArgumentException("NumTrueEvals must be >= 1");
        }
        if (numTotalEvals <= numTrueEvals) {
            throw new IllegalArgumentException("NumTotalEvals must be > NumTrueEvals");
        }
        return new Dampening(triggerId, triggerMode, Type.RELAXED_COUNT, numTrueEvals, numTotalEvals, 0L);
    }

    public static Dampening forRelaxedTime(String triggerId, Mode triggerMode, int numTrueEvals, long evalPeriod) {
        if (numTrueEvals < 1) {
            throw new IllegalArgumentException("NumTrueEvals must be >= 1");
        }
        if (evalPeriod < 1L) {
            throw new IllegalArgumentException("EvalPeriod must be >= 1ms");
        }
        return new Dampening(triggerId, triggerMode, Type.RELAXED_TIME, numTrueEvals, 0, evalPeriod);
    }

    public static Dampening forStrictTime(String triggerId, Mode triggerMode, long evalPeriod) {
        if (evalPeriod < 1L) {
            throw new IllegalArgumentException("EvalPeriod must be >= 1ms");
        }
        return new Dampening(triggerId, triggerMode, Type.STRICT_TIME, 0, 0, evalPeriod);
    }

    public static Dampening forStrictTimeout(String triggerId, Mode triggerMode, long evalPeriod) {
        if (evalPeriod < 1L) {
            throw new IllegalArgumentException("EvalPeriod must be >= 1ms");
        }
        return new Dampening(triggerId, triggerMode, Type.STRICT_TIMEOUT, 0, 0, evalPeriod);
    }

    public Dampening(String triggerId, Mode triggerMode, Type type, int evalTrueSetting, int evalTotalSetting, long evalTimeSetting) {
        this.triggerId = triggerId;
        this.type = type;
        this.evalTrueSetting = evalTrueSetting;
        this.evalTotalSetting = evalTotalSetting;
        this.evalTimeSetting = evalTimeSetting;
        this.triggerMode = triggerMode;
        this.updateId();
        this.reset();
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
        this.updateId();
    }

    public Mode getTriggerMode() {
        return this.triggerMode;
    }

    public void setTriggerMode(Mode triggerMode) {
        this.triggerMode = triggerMode;
        this.updateId();
    }

    public void setEvalTimeSetting(long evalTimeSetting) {
        this.evalTimeSetting = evalTimeSetting;
    }

    public void setEvalTotalSetting(int evalTotalSetting) {
        this.evalTotalSetting = evalTotalSetting;
    }

    public void setEvalTrueSetting(int evalTrueSetting) {
        this.evalTrueSetting = evalTrueSetting;
    }

    public void setSatisfied(boolean satisfied) {
        this.satisfied = satisfied;
    }

    public void setSatisfyingEvals(List<Set<ConditionEval>> satisfyingEvals) {
        this.satisfyingEvals = satisfyingEvals;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @JsonIgnore
    public int getNumTrueEvals() {
        return this.numTrueEvals;
    }

    public void setNumTrueEvals(int numTrueEvals) {
        this.numTrueEvals = numTrueEvals;
    }

    @JsonIgnore
    public long getTrueEvalsStartTime() {
        return this.trueEvalsStartTime;
    }

    public void setTrueEvalsStartTime(long trueEvalsStartTime) {
        this.trueEvalsStartTime = trueEvalsStartTime;
    }

    @JsonIgnore
    public int getNumEvals() {
        return this.numEvals;
    }

    public void setNumEvals(int numEvals) {
        this.numEvals = numEvals;
    }

    public Type getType() {
        return this.type;
    }

    public int getEvalTrueSetting() {
        return this.evalTrueSetting;
    }

    public int getEvalTotalSetting() {
        return this.evalTotalSetting;
    }

    public long getEvalTimeSetting() {
        return this.evalTimeSetting;
    }

    @JsonIgnore
    public Map<Integer, ConditionEval> getCurrentEvals() {
        return this.currentEvals;
    }

    @JsonIgnore
    public boolean isSatisfied() {
        return this.satisfied;
    }

    @JsonIgnore
    public List<Set<ConditionEval>> getSatisfyingEvals() {
        return new ArrayList<Set<ConditionEval>>(this.satisfyingEvals);
    }

    public void addSatisfyingEvals(Set<ConditionEval> satisfyingEvals) {
        this.satisfyingEvals.add(satisfyingEvals);
    }

    public void addSatisfyingEvals(ConditionEval ... satisfyingEvals) {
        this.satisfyingEvals.add(new HashSet<ConditionEval>(Arrays.asList(satisfyingEvals)));
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void perform(Match match, ConditionEval conditionEval) {
        if (null == match) {
            throw new IllegalArgumentException("Match can not be null");
        }
        if (null == conditionEval) {
            throw new IllegalArgumentException("ConditionEval can not be null");
        }
        this.currentEvals.put(conditionEval.getConditionSetIndex(), conditionEval);
        boolean trueEval = false;
        block0 : switch (match) {
            case ALL: {
                if (this.currentEvals.size() < conditionEval.getConditionSetSize()) {
                    return;
                }
                trueEval = true;
                for (ConditionEval ce : this.currentEvals.values()) {
                    if (ce.isMatch()) continue;
                    trueEval = false;
                    break block0;
                }
                break;
            }
            case ANY: {
                trueEval = false;
                for (ConditionEval ce : this.currentEvals.values()) {
                    if (!ce.isMatch()) continue;
                    trueEval = true;
                    break block0;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected Match type: " + match.name());
            }
        }
        long now = System.currentTimeMillis();
        if (this.type == Type.RELAXED_TIME && this.trueEvalsStartTime != 0L && now - this.trueEvalsStartTime > this.evalTimeSetting) {
            this.reset();
        }
        ++this.numEvals;
        if (trueEval) {
            ++this.numTrueEvals;
            this.addSatisfyingEvals(new HashSet<ConditionEval>(this.currentEvals.values()));
            switch (this.type) {
                case STRICT: 
                case RELAXED_COUNT: {
                    if (this.numTrueEvals != this.evalTrueSetting) break;
                    this.satisfied = true;
                    break;
                }
                case RELAXED_TIME: {
                    if (this.trueEvalsStartTime == 0L) {
                        this.trueEvalsStartTime = now;
                    }
                    if (this.numTrueEvals != this.evalTrueSetting || now - this.trueEvalsStartTime >= this.evalTimeSetting) break;
                    this.satisfied = true;
                    break;
                }
                case STRICT_TIME: 
                case STRICT_TIMEOUT: {
                    if (this.trueEvalsStartTime == 0L) {
                        this.trueEvalsStartTime = now;
                        break;
                    }
                    if (now - this.trueEvalsStartTime < this.evalTimeSetting) break;
                    this.satisfied = true;
                }
            }
        } else {
            switch (this.type) {
                case STRICT: 
                case STRICT_TIME: 
                case STRICT_TIMEOUT: {
                    this.reset();
                    break;
                }
                case RELAXED_COUNT: {
                    int numNeeded = this.evalTrueSetting - this.numTrueEvals;
                    int chancesLeft = this.evalTotalSetting - this.numEvals;
                    if (numNeeded <= chancesLeft) break;
                    this.reset();
                    break;
                }
            }
        }
    }

    public void reset() {
        this.numTrueEvals = 0;
        this.numEvals = 0;
        this.trueEvalsStartTime = 0L;
        this.satisfied = false;
        this.satisfyingEvals.clear();
    }

    public String log() {
        StringBuilder sb = new StringBuilder("[" + this.triggerId + ", numTrueEvals=" + this.numTrueEvals + ", numEvals=" + this.numEvals + ", trueEvalsStartTime=" + this.trueEvalsStartTime + ", satisfied=" + this.satisfied);
        if (this.satisfied) {
            for (Set<ConditionEval> ces : this.satisfyingEvals) {
                sb.append("\n\t[");
                String space = "";
                for (ConditionEval ce : ces) {
                    sb.append(space);
                    sb.append("[");
                    sb.append(ce.getLog());
                    sb.append("]");
                    space = " ";
                }
                sb.append("]");
            }
        }
        return sb.toString();
    }

    public String getDampeningId() {
        return this.dampeningId;
    }

    private void updateId() {
        StringBuilder sb = new StringBuilder(this.triggerId);
        sb.append("-").append(this.triggerMode.name());
        this.dampeningId = sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dampeningId == null ? 0 : this.dampeningId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dampening other = (Dampening)obj;
        return !(this.dampeningId == null ? other.dampeningId != null : !this.dampeningId.equals(other.dampeningId));
    }

    public String toString() {
        return "Dampening [satisfied=" + this.satisfied + ", triggerId=" + this.triggerId + ", triggerMode=" + (Object)((Object)this.triggerMode) + ", type=" + (Object)((Object)this.type) + ", evalTrueSetting=" + this.evalTrueSetting + ", evalTotalSetting=" + this.evalTotalSetting + ", evalTimeSetting=" + this.evalTimeSetting + ", numTrueEvals=" + this.numTrueEvals + ", numEvals=" + this.numEvals + ", trueEvalsStartTime=" + this.trueEvalsStartTime + "]";
    }

    public static enum Type {
        STRICT,
        RELAXED_COUNT,
        RELAXED_TIME,
        STRICT_TIME,
        STRICT_TIMEOUT;

    }
}

