/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.paging;

import java.util.Comparator;
import org.hawkular.alerts.api.model.event.Alert;
import org.hawkular.alerts.api.model.paging.Order;

public class AlertComparator
implements Comparator<Alert> {
    private Field field;
    private Order.Direction direction;

    public AlertComparator() {
        this("alertId", Order.Direction.ASCENDING);
    }

    public AlertComparator(String field, Order.Direction direction) {
        this.field = Field.getField(field);
        this.direction = direction;
    }

    @Override
    public int compare(Alert o1, Alert o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return 1;
        }
        if (o1 != null && o2 == null) {
            return -1;
        }
        int iOrder = this.direction == Order.Direction.ASCENDING ? 1 : -1;
        switch (this.field) {
            case ALERT_ID: {
                return o1.getAlertId().compareTo(o2.getAlertId()) * iOrder;
            }
            case CTIME: {
                return (int)((o1.getCtime() - o2.getCtime()) * (long)iOrder);
            }
            case SEVERITY: {
                if (o1.getSeverity() == null && o2.getSeverity() == null) {
                    return 0;
                }
                if (o1.getSeverity() == null && o2.getSeverity() != null) {
                    return 1;
                }
                if (o1.getSeverity() != null && o2.getSeverity() == null) {
                    return -1;
                }
                return o1.getSeverity().compareTo(o2.getSeverity()) * iOrder;
            }
            case STATUS: {
                if (o1.getStatus() == null && o2.getStatus() == null) {
                    return 0;
                }
                if (o1.getStatus() == null && o2.getStatus() != null) {
                    return 1;
                }
                if (o1.getStatus() != null && o2.getStatus() == null) {
                    return -1;
                }
                return o1.getStatus().compareTo(o2.getStatus()) * iOrder;
            }
            case CONTEXT: {
                if (o1.getContext() == null && o2.getContext() == null) {
                    return 0;
                }
                if (o1.getContext().isEmpty() && o2.getContext().isEmpty()) {
                    return 0;
                }
                if (!o1.getContext().containsKey(this.field.contextKey) && !o2.getContext().containsKey(this.field.contextKey)) {
                    return 0;
                }
                if (!o1.getContext().containsKey(this.field.contextKey) && o2.getContext().containsKey(this.field.contextKey)) {
                    return 1;
                }
                if (!o1.getContext().containsKey(this.field.contextKey) && !o2.getContext().containsKey(this.field.contextKey)) {
                    return -1;
                }
                return o1.getContext().get(this.field.contextKey).compareTo(o2.getContext().get(this.field.contextKey)) * iOrder;
            }
            case TRIGGER_DESCRIPTION: {
                String o1TriggerDesc = o1.getTrigger().getDescription();
                String o2TriggerDesc = o2.getTrigger().getDescription();
                if (o1TriggerDesc == null && o2TriggerDesc == null) {
                    return 0;
                }
                if (o1TriggerDesc == null && o2TriggerDesc != null) {
                    return 1;
                }
                if (o1TriggerDesc != null && o2TriggerDesc == null) {
                    return -1;
                }
                return o1TriggerDesc.compareTo(o2TriggerDesc) * iOrder;
            }
            case TRIGGER_ID: {
                String o1TriggerId = o1.getTrigger().getId();
                String o2TriggerId = o2.getTrigger().getId();
                if (o1TriggerId == null && o2TriggerId == null) {
                    return 0;
                }
                if (o1TriggerId == null && o2TriggerId != null) {
                    return 1;
                }
                if (o1TriggerId != null && o2TriggerId == null) {
                    return -1;
                }
                return o1TriggerId.compareTo(o2TriggerId) * iOrder;
            }
            case TRIGGER_NAME: {
                String o1TriggerName = o1.getTrigger().getName();
                String o2TriggerName = o2.getTrigger().getName();
                if (o1TriggerName == null && o2TriggerName == null) {
                    return 0;
                }
                if (o1TriggerName == null && o2TriggerName != null) {
                    return 1;
                }
                if (o1TriggerName != null && o2TriggerName == null) {
                    return -1;
                }
                return o1TriggerName.compareTo(o2TriggerName) * iOrder;
            }
        }
        return 0;
    }

    public static enum Field {
        ALERT_ID("alertId"),
        TRIGGER_DESCRIPTION("trigger.description"),
        TRIGGER_ID("trigger.id"),
        TRIGGER_NAME("trigger.name"),
        CTIME("ctime"),
        SEVERITY("severity"),
        STATUS("status"),
        CONTEXT("context");

        private String text;
        private String contextKey;

        private Field(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static Field getField(String text) {
            if (text == null || text.isEmpty()) {
                return ALERT_ID;
            }
            for (Field f : Field.values()) {
                if (!text.startsWith(f.getText())) continue;
                if (CONTEXT == f && text.length() > 8) {
                    f.contextKey = text.substring(8);
                }
                return f;
            }
            return ALERT_ID;
        }
    }
}

