/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.paging;

import java.util.Comparator;
import org.hawkular.alerts.api.model.paging.Order;
import org.hawkular.alerts.api.model.trigger.Trigger;

public class TriggerComparator
implements Comparator<Trigger> {
    private Field field;
    private Order.Direction direction;

    public TriggerComparator() {
        this(Field.NAME, Order.Direction.ASCENDING);
    }

    public TriggerComparator(Field field, Order.Direction direction) {
        this.field = field;
        this.direction = direction;
    }

    @Override
    public int compare(Trigger o1, Trigger o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return 1;
        }
        if (o1 != null && o2 == null) {
            return -1;
        }
        int iOrder = this.direction == Order.Direction.ASCENDING ? 1 : -1;
        switch (this.field) {
            case ID: {
                return o1.getId().compareTo(o2.getId()) * iOrder;
            }
            case DESCRIPTION: {
                if (o1.getDescription() == null && o2.getDescription() == null) {
                    return 0;
                }
                if (o1.getDescription() == null && o2.getDescription() != null) {
                    return 1;
                }
                if (o1.getDescription() != null && o2.getDescription() == null) {
                    return -1;
                }
                return o1.getDescription().compareTo(o2.getDescription()) * iOrder;
            }
            case ENABLED: {
                if (o1.isEnabled() == o2.isEnabled()) {
                    return 0;
                }
                return (o1.isEnabled() ? 1 : -1) * iOrder;
            }
            case NAME: {
                if (o1.getDescription() == null && o2.getName() == null) {
                    return 0;
                }
                if (o1.getName() == null && o2.getName() != null) {
                    return 1;
                }
                if (o1.getName() != null && o2.getName() == null) {
                    return -1;
                }
                return o1.getName().compareTo(o2.getName()) * iOrder;
            }
            case SEVERITY: {
                if (o1.getSeverity() == null && o2.getSeverity() == null) {
                    return 0;
                }
                if (o1.getSeverity() == null && o2.getSeverity() != null) {
                    return 1;
                }
                if (o1.getSeverity() != null && o2.getSeverity() == null) {
                    return -1;
                }
                return o1.getSeverity().compareTo(o2.getSeverity()) * iOrder;
            }
        }
        return 0;
    }

    public static enum Field {
        ID("id"),
        DESCRIPTION("description"),
        ENABLED("enabled"),
        NAME("name"),
        SEVERITY("severity");

        private String name;

        private Field(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Field getName(String name) {
            if (name == null || name.isEmpty()) {
                return NAME;
            }
            for (Field f : Field.values()) {
                if (f.getName().compareToIgnoreCase(name) != 0) continue;
                return f;
            }
            return NAME;
        }
    }
}

