/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.trigger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.hawkular.alerts.api.model.Severity;
import org.hawkular.alerts.api.model.event.EventType;
import org.hawkular.alerts.api.model.trigger.Match;
import org.hawkular.alerts.api.model.trigger.Mode;

public class Trigger {
    @JsonInclude
    private String tenantId;
    @JsonInclude
    private String id;
    @JsonInclude
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String description;
    @JsonInclude
    private EventType eventType;
    @JsonInclude
    private String eventCategory;
    @JsonInclude
    private String eventText;
    @JsonInclude
    private Severity severity;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected Map<String, String> context;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected Map<String, String> tags;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Set<String>> actions;
    @JsonInclude
    private boolean autoDisable;
    @JsonInclude
    private boolean autoEnable;
    @JsonInclude
    private boolean autoResolve;
    @JsonInclude
    private boolean autoResolveAlerts;
    @JsonInclude
    private Match autoResolveMatch;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String memberOf;
    @JsonInclude
    private boolean enabled;
    @JsonInclude
    private Match firingMatch;
    @JsonInclude
    private boolean orphan;
    @JsonInclude
    private boolean group;
    @JsonIgnore
    private Mode mode;
    @JsonIgnore
    private transient Match match;

    public Trigger() {
        this("defaultTenant", "defaultName");
    }

    public Trigger(String triggerId, String name) {
        this(null, triggerId, name, null);
    }

    public Trigger(String triggerId, String name, Map<String, String> context) {
        this(null, triggerId, name, context);
    }

    public Trigger(String tenantId, String id, String name) {
        this(tenantId, id, name, null, null);
    }

    public Trigger(String tenantId, String id, String name, Map<String, String> context) {
        this(tenantId, id, name, context, null);
    }

    public Trigger(String tenantId, String id, String name, Map<String, String> context, Map<String, String> tags) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Trigger id must be non-empty");
        }
        this.tenantId = tenantId;
        this.id = id;
        this.name = name;
        this.context = context;
        this.tags = tags;
        this.actions = new HashMap<String, Set<String>>();
        this.autoDisable = false;
        this.autoEnable = false;
        this.autoResolve = false;
        this.autoResolveAlerts = true;
        this.autoResolveMatch = Match.ALL;
        this.eventCategory = null;
        this.eventText = null;
        this.eventType = EventType.ALERT;
        this.memberOf = null;
        this.description = null;
        this.enabled = false;
        this.firingMatch = Match.ALL;
        this.orphan = false;
        this.group = false;
        this.severity = Severity.MEDIUM;
        this.match = Match.ALL;
        this.mode = Mode.FIRING;
    }

    public static String generateId() {
        return UUID.randomUUID().toString();
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Trigger name must be non-empty.");
        }
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public String getEventCategory() {
        return this.eventCategory;
    }

    public void setEventCategory(String eventCategory) {
        this.eventCategory = eventCategory;
    }

    public String getEventText() {
        return this.eventText;
    }

    public void setEventText(String eventText) {
        this.eventText = eventText;
    }

    public Map<String, String> getContext() {
        if (null == this.context) {
            this.context = new HashMap<String, String>();
        }
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public void addContext(String name, String value) {
        if (null == name || null == value) {
            throw new IllegalArgumentException("Context must have non-null name and value");
        }
        this.getContext().put(name, value);
    }

    public Map<String, String> getTags() {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public void addTag(String name, String value) {
        if (null == name || null == value) {
            throw new IllegalArgumentException("Tag must have non-null name and value");
        }
        this.getTags().put(name, value);
    }

    public boolean isAutoDisable() {
        return this.autoDisable;
    }

    public void setAutoDisable(boolean autoDisable) {
        this.autoDisable = autoDisable;
    }

    public boolean isAutoEnable() {
        return this.autoEnable;
    }

    public void setAutoEnable(boolean autoEnable) {
        this.autoEnable = autoEnable;
    }

    public boolean isAutoResolve() {
        return this.autoResolve;
    }

    public void setAutoResolve(boolean autoResolve) {
        this.autoResolve = autoResolve;
    }

    public boolean isAutoResolveAlerts() {
        return this.autoResolveAlerts;
    }

    public void setAutoResolveAlerts(boolean autoResolveAlerts) {
        this.autoResolveAlerts = autoResolveAlerts;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public Match getFiringMatch() {
        return this.firingMatch;
    }

    public Match getAutoResolveMatch() {
        return this.autoResolveMatch;
    }

    public Map<String, Set<String>> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, Set<String>> actions) {
        this.actions = actions;
    }

    public void addAction(String actionPlugin, String actionId) {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("ActionPlugin must be non-empty.");
        }
        if (actionId == null || actionId.isEmpty()) {
            throw new IllegalArgumentException("ActionId must be non-empty.");
        }
        if (this.actions.get(actionPlugin) == null) {
            this.actions.put(actionPlugin, new HashSet());
        }
        this.actions.get(actionPlugin).add(actionId);
    }

    public void addActions(String actionPlugin, Set<String> actionIds) {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("ActionPlugin must be non-empty.");
        }
        if (actionIds == null) {
            throw new IllegalArgumentException("ActionIds must be non null");
        }
        if (this.actions.get(actionPlugin) == null) {
            this.actions.put(actionPlugin, new HashSet());
        }
        this.actions.get(actionPlugin).addAll(actionIds);
    }

    public void removeAction(String actionPlugin, String actionId) {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("actionPlugin must be non-empty.");
        }
        if (actionId == null || actionId.isEmpty()) {
            throw new IllegalArgumentException("ActionId must be non-empty.");
        }
        if (this.actions.get(actionPlugin) != null) {
            this.actions.get(actionPlugin).remove(actionId);
        }
    }

    public String getMemberOf() {
        return this.memberOf;
    }

    public void setMemberOf(String memberOf) {
        this.memberOf = memberOf;
    }

    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    @JsonIgnore
    public boolean isMember() {
        return !this.isEmpty(this.memberOf);
    }

    private boolean isEmpty(String s) {
        return null == s || s.trim().isEmpty();
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public void setOrphan(boolean orphan) {
        this.orphan = orphan;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @JsonIgnore
    public boolean isLoadable() {
        return !this.group && this.enabled;
    }

    @JsonIgnore
    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.setMatch(this.mode == Mode.FIRING ? this.getFiringMatch() : this.getAutoResolveMatch());
    }

    @JsonIgnore
    public Match getMatch() {
        return this.match;
    }

    public void setMatch(Match match) {
        this.match = match;
    }

    public void setFiringMatch(Match firingMatch) {
        this.firingMatch = firingMatch;
        this.setMatch(this.mode == Mode.FIRING ? this.getFiringMatch() : this.getAutoResolveMatch());
    }

    public void setAutoResolveMatch(Match autoResolveMatch) {
        this.autoResolveMatch = autoResolveMatch;
        this.setMatch(this.mode == Mode.FIRING ? this.getFiringMatch() : this.getAutoResolveMatch());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trigger trigger = (Trigger)o;
        if (this.id != null ? !this.id.equals(trigger.id) : trigger.id != null) {
            return false;
        }
        return !(this.tenantId == null ? trigger.tenantId != null : !this.tenantId.equals(trigger.tenantId));
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.tenantId != null ? this.tenantId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Trigger [tenantId=" + this.tenantId + ", id=" + this.id + ", triggerType=" + this.eventType.name() + ", name=" + this.name + ", description=" + this.description + ", eventType=" + (Object)((Object)this.eventType) + ", eventCategory=" + this.eventCategory + ", eventText=" + this.eventText + ", severity=" + (Object)((Object)this.severity) + ", context=" + this.context + ", actions=" + this.actions + ", autoDisable=" + this.autoDisable + ", autoEnable=" + this.autoEnable + ", autoResolve=" + this.autoResolve + ", autoResolveAlerts=" + this.autoResolveAlerts + ", autoResolveMatch=" + (Object)((Object)this.autoResolveMatch) + ", memberOf=" + this.memberOf + ", enabled=" + this.enabled + ", firingMatch=" + (Object)((Object)this.firingMatch) + ", orphan=" + this.orphan + ", group=" + this.group + ", mode=" + (Object)((Object)this.mode) + ", tags=" + this.tags + "]";
    }
}

